/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2;

import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.SecurityException;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.store.NitriteStore;
import org.dizitart.no2.util.StringUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;

final class Security {
    private static final Random random = new SecureRandom();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MVStore createSecurely(MVStore.Builder builder, String userId, String password) {
        MVStore store = builder.open();
        try {
            if (!StringUtils.isNullOrEmpty(password) && !StringUtils.isNullOrEmpty(userId)) {
                byte[] salt = Security.getNextSalt();
                byte[] hash = Security.hash(password.toCharArray(), salt);
                UserCredential userCredential = new UserCredential();
                userCredential.setPasswordHash(hash);
                userCredential.setPasswordSalt(salt);
                MVMap userMap = store.openMap("$nitrite_users");
                userMap.put((Object)userId, (Object)userCredential);
            }
        }
        finally {
            store.commit();
        }
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static MVStore openSecurely(MVStore.Builder builder, String userId, String password) {
        MVStore store = builder.open();
        boolean success = false;
        try {
            if (!StringUtils.isNullOrEmpty(password) && !StringUtils.isNullOrEmpty(userId)) {
                if (!store.hasMap("$nitrite_users")) {
                    throw new SecurityException(ErrorMessage.NO_USER_MAP_FOUND);
                }
                MVMap userMap = store.openMap("$nitrite_users");
                UserCredential userCredential = (UserCredential)userMap.get((Object)userId);
                if (userCredential == null) throw new SecurityException(ErrorMessage.NULL_USER_CREDENTIAL);
                byte[] salt = userCredential.getPasswordSalt();
                byte[] expectedHash = userCredential.getPasswordHash();
                if (!Security.isExpectedPassword(password.toCharArray(), salt, expectedHash)) {
                    throw new SecurityException(ErrorMessage.INVALID_USER_PASSWORD);
                }
            } else if (store.hasMap("$nitrite_users")) {
                throw new SecurityException(ErrorMessage.USER_MAP_SHOULD_NOT_EXISTS);
            }
            success = true;
            MVStore mVStore = store;
            return mVStore;
        }
        finally {
            if (!success) {
                store.close();
            }
        }
    }

    static boolean validateUserPassword(NitriteStore store, String userId, String password) {
        if (StringUtils.isNullOrEmpty(userId) && StringUtils.isNullOrEmpty(password) && !store.hasMap("$nitrite_users")) {
            return true;
        }
        if (!StringUtils.isNullOrEmpty(userId)) {
            if (StringUtils.isNullOrEmpty(password)) {
                return false;
            }
            NitriteMap userMap = store.openMap("$nitrite_users");
            if (userMap.containsKey(userId)) {
                UserCredential credential = (UserCredential)userMap.get(userId);
                byte[] salt = credential.getPasswordSalt();
                byte[] expectedHash = credential.getPasswordHash();
                return Security.isExpectedPassword(password.toCharArray(), salt, expectedHash);
            }
        }
        return false;
    }

    private static byte[] getNextSalt() {
        byte[] salt = new byte[16];
        random.nextBytes(salt);
        return salt;
    }

    private static byte[] hash(char[] password, byte[] salt) {
        PBEKeySpec spec = new PBEKeySpec(password, salt, 10000, 256);
        Arrays.fill(password, '\u0000');
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            byte[] byArray = skf.generateSecret(spec).getEncoded();
            return byArray;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalArgumentException("Error while hashing a password: " + e.getMessage(), e);
        }
        finally {
            spec.clearPassword();
        }
    }

    private static boolean isExpectedPassword(char[] password, byte[] salt, byte[] expectedHash) {
        byte[] pwdHash = Security.hash(password, salt);
        Arrays.fill(password, '\u0000');
        if (pwdHash.length != expectedHash.length) {
            return false;
        }
        for (int i = 0; i < pwdHash.length; ++i) {
            if (pwdHash[i] == expectedHash[i]) continue;
            return false;
        }
        return true;
    }

    private Security() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class UserCredential
    implements Serializable {
        private static final long serialVersionUID = 1647971266L;
        private byte[] passwordHash;
        private byte[] passwordSalt;

        public byte[] getPasswordHash() {
            return this.passwordHash;
        }

        public byte[] getPasswordSalt() {
            return this.passwordSalt;
        }

        public void setPasswordHash(byte[] passwordHash) {
            this.passwordHash = passwordHash;
        }

        public void setPasswordSalt(byte[] passwordSalt) {
            this.passwordSalt = passwordSalt;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserCredential)) {
                return false;
            }
            UserCredential other = (UserCredential)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.equals(this.getPasswordHash(), other.getPasswordHash())) {
                return false;
            }
            return Arrays.equals(this.getPasswordSalt(), other.getPasswordSalt());
        }

        protected boolean canEqual(Object other) {
            return other instanceof UserCredential;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getPasswordHash());
            result = result * 59 + Arrays.hashCode(this.getPasswordSalt());
            return result;
        }

        public String toString() {
            return "Security.UserCredential(passwordHash=" + Arrays.toString(this.getPasswordHash()) + ", passwordSalt=" + Arrays.toString(this.getPasswordSalt()) + ")";
        }
    }
}

