/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.interaction.javafx;

import java.util.ArrayList;
import org.luwrain.core.Log;
import org.luwrain.interaction.javafx.OnScreenLine;

final class OnScreenLineTracker {
    private ArrayList<Vertex> vertices = new ArrayList();

    OnScreenLineTracker() {
    }

    void cover(int pos1, int pos2) {
        if (pos1 < 0 || pos1 > pos2) {
            return;
        }
        this.addVertex(pos1);
        this.addVertex(pos2 + 1);
        for (int i = 0; i < this.vertices.size(); ++i) {
            Vertex v = this.vertices.get(i);
            if (v.pos >= pos1 && v.pos <= pos2) {
                v.followed = true;
            }
            if (v.pos > pos2) break;
        }
        this.removeNeedless();
    }

    void uncover(int pos1, int pos2) {
        if (pos1 < 0 || pos1 > pos2) {
            return;
        }
        this.addVertex(pos1);
        this.addVertex(pos2 + 1);
        for (int i = 0; i < this.vertices.size(); ++i) {
            Vertex v = this.vertices.get(i);
            if (v.pos >= pos1 && v.pos <= pos2) {
                v.followed = false;
            }
            if (v.pos > pos2) break;
        }
        this.removeNeedless();
    }

    void clear() {
        this.vertices.clear();
    }

    OnScreenLine[] getLines() {
        if (this.vertices.size() < 2) {
            return new OnScreenLine[0];
        }
        OnScreenLine[] lines = new OnScreenLine[this.vertices.size() / 2];
        for (int i = 0; i < this.vertices.size() / 2; ++i) {
            if (!this.vertices.get((int)(2 * i)).followed || this.vertices.get((int)(2 * i + 1)).followed || this.vertices.get((int)(2 * i)).pos >= this.vertices.get((int)(2 * i + 1)).pos) {
                Log.warning((String)"interaction", (String)"on screen lines tracking  is broken, some of them will be missed");
                return new OnScreenLine[0];
            }
            lines[i] = new OnScreenLine(this.vertices.get((int)(2 * i)).pos, this.vertices.get((int)(2 * i + 1)).pos - 1);
        }
        return lines;
    }

    private void addVertex(int pos) {
        boolean followed;
        int i;
        for (i = 0; i < this.vertices.size() && this.vertices.get((int)i).pos < pos; ++i) {
        }
        if (i < this.vertices.size() && this.vertices.get((int)i).pos == pos) {
            return;
        }
        boolean bl = followed = i > 0 ? this.vertices.get((int)(i - 1)).followed : false;
        if (i < this.vertices.size()) {
            this.vertices.add(i, new Vertex(pos, followed));
        } else {
            this.vertices.add(new Vertex(pos, followed));
        }
    }

    private void removeNeedless() {
        int offset;
        for (offset = 0; offset < this.vertices.size() && !this.vertices.get((int)offset).followed; ++offset) {
        }
        if (offset >= this.vertices.size()) {
            this.vertices.clear();
            return;
        }
        if (offset > 0) {
            this.vertices = new ArrayList<Vertex>(this.vertices.subList(offset, this.vertices.size()));
        }
        if (this.vertices.size() < 2) {
            return;
        }
        offset = 0;
        for (int i = 1; i < this.vertices.size(); ++i) {
            if (this.vertices.get((int)(i - 1 - offset)).followed == this.vertices.get((int)i).followed) {
                ++offset;
                continue;
            }
            this.vertices.set(i - offset, this.vertices.get(i));
        }
        this.vertices = new ArrayList<Vertex>(this.vertices.subList(0, this.vertices.size() - offset));
        if (!this.vertices.isEmpty() && this.vertices.size() % 2 != 0) {
            Log.warning((String)"interaction", (String)("on screen lines tracking has odd vertex count:" + this.vertices.size() + ", clearing content"));
            this.vertices.clear();
        }
    }

    final class Vertex {
        final int pos;
        boolean followed;

        Vertex(int pos, boolean followed) {
            this.pos = pos;
            this.followed = followed;
        }
    }
}

