/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.studio.syntax.java;

import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.luwrain.antlr.java.JavaBaseListener;
import org.luwrain.antlr.java.JavaLexer;
import org.luwrain.antlr.java.JavaParser;
import org.luwrain.studio.syntax.SpanTree;

public final class JavaSyntax {
    public final Source source;
    public final SpanTree spanTree = new SpanTree();

    public JavaSyntax(Source source) {
        this.source = source;
    }

    void parse() {
        JavaLexer lexer = new JavaLexer((CharStream)CharStreams.fromString((String)this.source.getText()));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        JavaParser parser = new JavaParser((TokenStream)tokens);
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        JavaParser.CompilationUnitContext tree = parser.compilationUnit();
        ParseTreeWalker walker = new ParseTreeWalker();
        JavaBaseListener listener = new JavaBaseListener(){

            public void enterClassBody(JavaParser.ClassBodyContext c) {
                SpanTree.Span span = JavaSyntax.this.spanTree.addSpan();
                span.setFromPos(c.getStart().getStartIndex());
                span.setToPos(c.getStop().getStartIndex());
            }

            public void exitClassBody(JavaParser.ClassBodyContext c) {
                JavaSyntax.this.spanTree.pop();
            }

            public void enterBlock(JavaParser.BlockContext c) {
                SpanTree.Span span = JavaSyntax.this.spanTree.addSpan();
                span.setFromPos(c.getStart().getStartIndex());
                span.setToPos(c.getStop().getStartIndex());
            }

            public void exitBlock(JavaParser.BlockContext c) {
                JavaSyntax.this.spanTree.pop();
            }

            public void enterClassDeclaration(JavaParser.ClassDeclarationContext ctx) {
                if (ctx.normalClassDeclaration() != null) {
                    // empty if block
                }
            }

            public void enterPackageDeclaration(JavaParser.PackageDeclarationContext ctx) {
                Object s = "";
                for (JavaParser.PackageNameContext c = ctx.packageName(); c != null; c = c.packageName()) {
                    s = c.identifier().Identifier().toString() + "." + (String)s;
                }
            }
        };
        walker.walk((ParseTreeListener)listener, (ParseTree)tree);
    }

    public static interface Source {
        public String getText();
    }
}

