/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.studio.syntax;

import java.util.ArrayList;
import org.luwrain.core.Lines;
import org.luwrain.core.NullCheck;

public class Source
implements Lines {
    private static final char NL = '\n';
    private String content = "";
    private String[] lines = new String[0];

    public Source(String content) {
        NullCheck.notNull((Object)content, (String)"content");
        if (!content.isEmpty()) {
            this.content = content.replaceAll("\r\n", "\n").replaceAll("\r", "\n");
            this.lines = this.content.split("\n", -1);
        }
    }

    public Source(String[] lines) {
        NullCheck.notNullItems((Object[])lines, (String)"lines");
        this.lines = (String[])lines.clone();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            if (i == 0) {
                b.append(lines[0]);
                continue;
            }
            b.append('\n').append(lines[i]);
        }
        this.content = new String(b);
    }

    public Source(Lines lines) {
        NullCheck.notNull((Object)lines, (String)"lines");
        ArrayList<String> l = new ArrayList<String>();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < lines.getLineCount(); ++i) {
            String line = lines.getLine(i);
            l.add(line);
            if (i > 0) {
                b.append('\n');
            }
            b.append(line);
        }
        this.lines = l.toArray(new String[l.size()]);
        this.content = new String(b);
    }

    public int getLineStart(int lineIndex) {
        if (lineIndex < 0) {
            throw new IllegalArgumentException("lineIndex can't be negative");
        }
        if (lineIndex > this.lines.length) {
            throw new IllegalArgumentException("lineIndex can't be greater than number of lines");
        }
        int res = 0;
        for (int i = 0; i < lineIndex; ++i) {
            res += this.lines[i].length() + 1;
        }
        return res;
    }

    public int getLineWithPos(int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("pos can't be negative");
        }
        int res = 0;
        for (int i = 0; i < this.lines.length; ++i) {
            if (pos <= res + this.lines[i].length()) {
                return i;
            }
            res += this.lines[i].length() + 1;
        }
        return -1;
    }

    public int getLineCount() {
        return this.lines.length;
    }

    public String getLine(int index) {
        return this.lines[index];
    }

    public String[] getLines() {
        return (String[])this.lines.clone();
    }

    public String getText() {
        return this.content;
    }

    public int length() {
        return this.content.length();
    }
}

