/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.studio.edit.tex;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.core.MutableMarkedLines;
import org.luwrain.core.NullCheck;
import org.luwrain.studio.Editing;
import org.luwrain.studio.IDE;
import org.luwrain.studio.Part;
import org.luwrain.studio.Project;
import org.luwrain.studio.edit.tex.Place;
import org.luwrain.studio.edit.tex.PlaceCollector;
import org.luwrain.studio.edit.tex.TexEditing;

public final class TexSourceFile
implements Part {
    private static final Logger log = LogManager.getLogger();
    private String name = null;
    private String path = null;
    transient List<Place> places = new ArrayList<Place>();
    transient MutableMarkedLines content = null;
    final transient AtomicBoolean modified = new AtomicBoolean(false);
    private transient IDE ide = null;
    private transient Project proj = null;
    private transient File projDir = null;

    public TexSourceFile() {
        this(null, null);
    }

    public TexSourceFile(String name, String path) {
        this.name = name;
        this.path = path;
    }

    public void init(Project proj, IDE ide) {
        NullCheck.notNull((Object)proj, (String)"proj");
        NullCheck.notNull((Object)ide, (String)"ide");
        this.proj = proj;
        this.ide = ide;
        this.projDir = proj.getProjectDir();
        new PlaceCollector();
    }

    @Override
    public Part[] getChildParts() {
        return this.places.toArray(new Part[this.places.size()]);
    }

    @Override
    public Editing startEditing() throws IOException {
        File file = this.getFile();
        log.trace("Opening for editing the tex file " + file.getAbsolutePath());
        return new TexEditing(this.ide, this, 0, 0);
    }

    @Override
    public String getTitle() {
        return this.name != null ? this.name : "NONAME";
    }

    public String toString() {
        return this.getTitle();
    }

    File getFile() {
        return new File(this.projDir, this.path);
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof TexSourceFile) {
            TexSourceFile f = (TexSourceFile)o;
            return this.path.equals(f.path);
        }
        return false;
    }

    @Override
    public Part.Action[] getActions() {
        return new Part.Action[0];
    }
}

