/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.studio.edit.tex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.PatternSyntaxException;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.EditSpellChecking;
import org.luwrain.controls.MutableMarkedLinesImpl;
import org.luwrain.controls.edit.EditArea;
import org.luwrain.controls.edit.MultilineEdit;
import org.luwrain.controls.edit.MultilineEditCorrector;
import org.luwrain.core.HookContainer;
import org.luwrain.core.Lines;
import org.luwrain.core.Luwrain;
import org.luwrain.core.MarkedLines;
import org.luwrain.core.MutableLines;
import org.luwrain.core.MutableMarkedLines;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;
import org.luwrain.popups.Popups;
import org.luwrain.script.controls.EditCorrectorHooks;
import org.luwrain.studio.IDE;
import org.luwrain.studio.Part;
import org.luwrain.studio.edit.TextEditingBase;
import org.luwrain.studio.edit.tex.Strings;
import org.luwrain.studio.edit.tex.TexAppearance;
import org.luwrain.studio.edit.tex.TexNewLineIndent;
import org.luwrain.studio.edit.tex.TexSourceFile;
import org.luwrain.util.TextFragmentUtils;

final class TexEditing
extends TextEditingBase {
    final EditSpellChecking spellChecking;
    final Strings strings;
    final TexSourceFile sourceFile;

    TexEditing(IDE ide, TexSourceFile sourceFile, int x, int y) throws IOException {
        super(ide, sourceFile.getFile(), x, y);
        this.spellChecking = new EditSpellChecking(ide.getLuwrainObj());
        this.sourceFile = sourceFile;
        this.strings = (Strings)ide.getLuwrainObj().i18n().getStrings(Strings.class.getName());
        if (sourceFile.content == null) {
            this.load();
        }
    }

    @Override
    public EditArea.Params getEditParams(ControlContext context) {
        EditArea.Params params = new EditArea.Params();
        params.context = context;
        params.name = this.file.getName();
        params.content = this.getContent();
        params.appearance = new TexAppearance(context, (MarkedLines)this.getContent());
        params.inputEventListeners = new ArrayList<EditArea.InputEventListener>(Arrays.asList(this.createEditAreaInputEventHook()));
        params.changeListeners = new ArrayList<EditArea.ChangeListener>(Arrays.asList((edit, lines, hotPoint) -> this.sourceFile.modified.set(true), this.spellChecking));
        params.editFactory = editParams -> {
            MultilineEditCorrector base = (MultilineEditCorrector)editParams.model;
            editParams.model = new EditCorrectorHooks((HookContainer)this.ide.getScriptCore(), (MultilineEdit.Model)new TexNewLineIndent(base), "luwrain.studio.tex");
            this.setEdit(new MultilineEdit(editParams), (MutableLines)this.getContent());
            return this.getEdit();
        };
        return params;
    }

    @Override
    public MutableMarkedLines getContent() {
        if (this.sourceFile.content == null) {
            this.sourceFile.content = new MutableMarkedLinesImpl();
        }
        return this.sourceFile.content;
    }

    @Override
    public AtomicBoolean getModified() {
        return this.sourceFile.modified;
    }

    @Override
    public Part.Action[] getActions() {
        return Part.actions(Part.action(this.strings.actAddFrame(), new InputEvent('f', EnumSet.of(InputEvent.Modifiers.ALT, InputEvent.Modifiers.SHIFT)), this::addFrame), Part.action(this.strings.actAddUnordered(), new InputEvent('u', EnumSet.of(InputEvent.Modifiers.ALT, InputEvent.Modifiers.SHIFT)), this::addItemize), Part.action(this.strings.actAddOrdered(), new InputEvent('o', EnumSet.of(InputEvent.Modifiers.ALT, InputEvent.Modifiers.SHIFT)), this::addEnumerate), Part.action(this.strings.actAddListItem(), new InputEvent('i', EnumSet.of(InputEvent.Modifiers.ALT, InputEvent.Modifiers.SHIFT)), this::addItem), Part.action(this.getAppearance().indent ? this.strings.actDisableIndentSpeaking() : this.strings.actEnableIndentSpeaking(), new InputEvent(InputEvent.Special.F5, EnumSet.of(InputEvent.Modifiers.ALT, InputEvent.Modifiers.SHIFT)), this::toggleIndent), Part.action(this.strings.actSuggestCorrection(), new InputEvent('s', EnumSet.of(InputEvent.Modifiers.ALT, InputEvent.Modifiers.SHIFT)), this::suggestCorrection), Part.action(this.strings.actReplace(), new InputEvent('r', EnumSet.of(InputEvent.Modifiers.ALT, InputEvent.Modifiers.SHIFT)), this::replace), Part.action(this.strings.actGotoLine(), new InputEvent('g', EnumSet.of(InputEvent.Modifiers.ALT, InputEvent.Modifiers.SHIFT)), this::gotoLine));
    }

    private boolean enableIndent() {
        this.getEdit().getMultilineEditAppearance();
        return false;
    }

    private boolean addFrame(IDE ide) {
        NullCheck.notNull((Object)ide, (String)"ide");
        if (!this.insertText(new String[]{"\\begin{frame}", "  \\frametitle{}", "\\end{frame}"})) {
            return false;
        }
        ide.getLuwrainObj().message("frame", Luwrain.MessageType.OK);
        return true;
    }

    private boolean addItemize(IDE ide) {
        NullCheck.notNull((Object)ide, (String)"ide");
        if (!this.insertText(new String[]{"\\begin{itemize}", "\\item{}", "\\end{itemize}"})) {
            return false;
        }
        ide.getLuwrainObj().message("Itemize", Luwrain.MessageType.OK);
        return true;
    }

    private boolean addEnumerate(IDE ide) {
        NullCheck.notNull((Object)ide, (String)"ide");
        if (!this.insertText(new String[]{"\\begin{enumerate}", "\\item{}", "\\end{enumerate}"})) {
            return false;
        }
        ide.getLuwrainObj().message("Enumerate", Luwrain.MessageType.OK);
        return true;
    }

    private boolean addItem(IDE ide) {
        if (!this.insertText("\\item{}")) {
            return false;
        }
        ide.getLuwrainObj().message("item", Luwrain.MessageType.OK);
        return true;
    }

    private boolean toggleIndent(IDE ide) {
        boolean newState;
        boolean oldState = this.getAppearance().indent;
        this.getAppearance().indent = newState = !oldState;
        ide.getLuwrainObj().message(newState ? "\u0412\u043a\u043b\u044e\u0447\u0435\u043d\u043e \u0447\u0442\u0435\u043d\u0438\u0435 \u043e\u0442\u0441\u0442\u0443\u043f\u043e\u0432" : "\u041e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u043e \u0447\u0442\u0435\u043d\u0438\u0435 \u043e\u0442\u0441\u0442\u0443\u043f\u043e\u0432", Luwrain.MessageType.OK);
        return true;
    }

    private boolean replace(IDE ide) {
        String replaceExp = Popups.textNotEmpty((Luwrain)ide.getLuwrainObj(), (String)"\u0417\u0430\u043c\u0435\u043d\u0430", (String)"\u0417\u0430\u043c\u0435\u043d\u0438\u0442\u044c:", (String)"");
        if (replaceExp == null) {
            return true;
        }
        String replaceWith = Popups.text((Luwrain)ide.getLuwrainObj(), (String)"\u0417\u0430\u043c\u0435\u043d\u0430", (String)"\u0417\u0430\u043c\u0435\u043d\u0438\u0442\u044c \u043d\u0430:", (String)"");
        if (replaceWith == null) {
            return true;
        }
        try {
            super.replaceStr(replaceExp, replaceWith);
        }
        catch (PatternSyntaxException e) {
            ide.getLuwrainObj().message("\u0412\u0432\u0435\u0434\u0451\u043d\u043d\u0430\u044f \u0441\u0442\u0440\u043e\u043a\u0430 \u0434\u043b\u044f \u0437\u0430\u043c\u0435\u043d\u044b \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u043c \u0440\u0435\u0433\u0443\u043b\u044f\u0440\u043d\u044b\u043c \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435\u043c", Luwrain.MessageType.ERROR);
        }
        return true;
    }

    private boolean gotoLine(IDE ide) {
        int lineNum;
        String lineNumStr = Popups.textNotEmpty((Luwrain)ide.getLuwrainObj(), (String)"\u041f\u0435\u0440\u0435\u0439\u0442\u0438 \u043d\u0430 \u0441\u0442\u0440\u043e\u043a\u0443", (String)"\u041d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438:", (String)"");
        if (lineNumStr == null) {
            return true;
        }
        try {
            lineNum = Integer.parseInt(lineNumStr);
        }
        catch (NumberFormatException e) {
            ide.getLuwrainObj().message("\u0412\u0432\u0435\u0434\u0451\u043d\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u043c \u043d\u043e\u043c\u0435\u0440\u043e\u043c \u0441\u0442\u0440\u043e\u043a\u0438", Luwrain.MessageType.ERROR);
            return true;
        }
        if (lineNum <= 0 || lineNum > this.getContent().getLineCount()) {
            ide.getLuwrainObj().message("\u0412\u0432\u0435\u0434\u0451\u043d\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u044b \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0445 \u043d\u043e\u043c\u0435\u0440\u043e\u0432 \u0441\u0442\u0440\u043e\u043a\u0438", Luwrain.MessageType.ERROR);
            return true;
        }
        return true;
    }

    private boolean suggestCorrection(IDE ide) {
        String word = new TextFragmentUtils((Lines)this.getContent()).getWord(this.getHotPointX(), this.getHotPointY());
        if (word == null) {
            return false;
        }
        List suggestions = this.spellChecking.getSpellChecker().suggestCorrections(word);
        if (suggestions != null && (suggestions == null || suggestions.isEmpty())) {
            return false;
        }
        String correction = (String)Popups.fixedList((Luwrain)ide.getLuwrainObj(), (String)this.strings.suggestCorrectionsPopupName(), (Object[])suggestions.toArray(new String[suggestions.size()]));
        if (correction == null) {
            return true;
        }
        this.getContent().update(lines -> {
            String newLine = new TextFragmentUtils((Lines)lines).replaceWord(this.getHotPointX(), this.getHotPointY(), correction);
            lines.setLine(this.getHotPointY(), newLine);
        });
        return true;
    }

    protected TexAppearance getAppearance() {
        return (TexAppearance)super.getAppearance();
    }
}

