/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.studio.edit.tex;

import org.luwrain.controls.ControlContext;
import org.luwrain.controls.edit.DefaultEditAreaAppearance;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Hint;
import org.luwrain.core.LineMarks;
import org.luwrain.core.Luwrain;
import org.luwrain.core.MarkedLines;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.nlp.SpellProblem;

final class TexAppearance
extends DefaultEditAreaAppearance {
    final MarkedLines content;
    boolean indent = false;

    TexAppearance(ControlContext context, MarkedLines content) {
        super(context);
        NullCheck.notNull((Object)content, (String)"content");
        this.content = content;
    }

    public void announceLine(int index, String line) {
        int indentLen;
        if (line.trim().isEmpty()) {
            this.context.setEventResponse(DefaultEventResponse.hint((Hint)(line.isEmpty() ? Hint.EMPTY_LINE : Hint.SPACES)));
            return;
        }
        boolean hasSpellProblems = false;
        if (this.content.getLineMarks(index) != null) {
            LineMarks.Mark[] marks;
            for (LineMarks.Mark m : marks = this.content.getLineMarks(index).getMarks()) {
                if (m.getMarkObject() == null || !(m.getMarkObject() instanceof SpellProblem)) continue;
                hasSpellProblems = true;
                break;
            }
        }
        StringBuilder b = new StringBuilder();
        if (this.indent && (indentLen = this.getIndentLen(line)) > 0) {
            b.append("\u041e\u0442\u0441\u0442\u0443\u043f ").append(String.valueOf(indentLen)).append(" ");
        }
        b.append(this.context.getSpeakableText(line, Luwrain.SpeakableTextType.PROGRAMMING));
        if (hasSpellProblems) {
            this.context.setEventResponse(DefaultEventResponse.text((Sounds)Sounds.SPELLING, (String)new String(b)));
        } else {
            this.context.setEventResponse(DefaultEventResponse.text((String)new String(b)));
        }
    }

    private int getIndentLen(String line) {
        int res = 0;
        for (int i = 0; i < line.length() && Character.isWhitespace(line.charAt(i)); ++i) {
            ++res;
        }
        return res;
    }
}

