/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.studio.backends.tex;

import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.IOException;
import org.luwrain.core.NullCheck;
import org.luwrain.studio.Editing;
import org.luwrain.studio.IDE;
import org.luwrain.studio.Part;
import org.luwrain.studio.backends.tex.TexEditing;
import org.luwrain.studio.backends.tex.TexProject;

final class TexSourceFile
implements Part {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="path")
    private String path = null;
    private transient TexProject proj = null;
    private transient IDE ide = null;

    TexSourceFile() {
        this(null, null);
    }

    TexSourceFile(String name, String path) {
        this.name = name;
        this.path = path;
    }

    void init(TexProject proj, IDE ide) {
        NullCheck.notNull((Object)proj, (String)"proj");
        NullCheck.notNull((Object)ide, (String)"ide");
        this.proj = proj;
        this.ide = ide;
    }

    @Override
    public String getTitle() {
        return this.name != null ? this.name : "NONAME";
    }

    @Override
    public Part[] getChildParts() {
        return new Part[0];
    }

    @Override
    public Editing startEditing() throws IOException {
        return new TexEditing(this.ide, new File(this.proj.getProjectDir(), this.path));
    }

    public String toString() {
        return this.getTitle();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TexSourceFile)) {
            return false;
        }
        TexSourceFile f = (TexSourceFile)o;
        return this.path.equals(f.path);
    }

    @Override
    public Part.Action[] getActions() {
        return new Part.Action[0];
    }
}

