/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.studio.backends.tex;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import org.luwrain.core.NullCheck;
import org.luwrain.studio.IDE;
import org.luwrain.studio.Part;
import org.luwrain.studio.Project;
import org.luwrain.studio.backends.tex.Strings;
import org.luwrain.studio.backends.tex.TexFolder;

public final class TexProject
implements Project {
    public static final String KEY = "---LUWRAIN-PROJECT-TEX---";
    @SerializedName(value="name")
    private String projName = null;
    @SerializedName(value="projKey")
    private String key = "---LUWRAIN-PROJECT-TEX---";
    @SerializedName(value="folders")
    private TexFolder rootFolder = null;
    private transient File projFile = null;
    private transient File projDir = null;
    private transient IDE ide = null;
    private transient Strings strings = null;
    private final transient Gson gson = new Gson();

    @Override
    public Part getPartsRoot() {
        return this.rootFolder;
    }

    @Override
    public Part getMainSourceFile() {
        return null;
    }

    Strings getStrings() {
        return this.strings;
    }

    @Override
    public void close() {
        this.save();
    }

    void setProjectFile(File projFile) {
        File parent = projFile.getParentFile();
        if (parent == null) {
            throw new IllegalArgumentException("projFile must have the not-null parent");
        }
        this.projDir = parent;
        this.projFile = projFile;
    }

    @Override
    public File getProjectDir() {
        if (this.projDir == null) {
            throw new RuntimeException("The project does not have any project directory information");
        }
        return this.projDir;
    }

    private void finalizeLoading(IDE ide) {
        NullCheck.notNull((Object)ide, (String)"ide");
        if (this.rootFolder == null) {
            this.rootFolder = new TexFolder();
            this.rootFolder.setName("Tex root");
        }
        this.rootFolder.init(this, ide);
        this.strings = (Strings)ide.getLuwrainObj().i18n().getStrings("luwrain.studio.tex");
        NullCheck.notNull((Object)this.strings, (String)"strings");
    }

    public String getProjName() {
        return this.projName != null ? this.projName.trim() : "";
    }

    public void setProjName(String projName) {
        NullCheck.notNull((Object)projName, (String)"projName");
        if (projName.trim().isEmpty()) {
            throw new IllegalArgumentException("projName can't be empty");
        }
        this.projName = projName.trim();
    }

    public TexFolder getRootFolder() {
        return this.rootFolder;
    }

    public void setRootFolder(TexFolder rootFolder) {
        NullCheck.notNull((Object)rootFolder, (String)"rootFolder");
        this.rootFolder = rootFolder;
    }

    void save() {
        if (this.projFile == null) {
            throw new IllegalStateException("projFile is not set");
        }
        try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.projFile), "UTF-8"));){
            this.gson.toJson((Object)this, (Appendable)w);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Project load(File projFile, IDE ide) throws IOException {
        NullCheck.notNull((Object)projFile, (String)"projFile");
        NullCheck.notNull((Object)ide, (String)"ide");
        Gson gson = new Gson();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(projFile), "UTF-8"));){
            TexProject proj = (TexProject)gson.fromJson((Reader)reader, TexProject.class);
            proj.setProjectFile(projFile);
            proj.finalizeLoading(ide);
            TexProject texProject = proj;
            return texProject;
        }
    }
}

