/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.message;

import java.io.File;
import org.luwrain.app.message.App;
import org.luwrain.app.message.Strings;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Popup;
import org.luwrain.pim.PimException;
import org.luwrain.pim.mail.persistence.model.Account;
import org.luwrain.popups.Popups;
import org.luwrain.popups.pim.CcEditPopup;
import org.luwrain.popups.pim.ChooseMailPopup;

final class Conv {
    private final App app;
    private final Luwrain luwrain;
    private final Strings strings;

    Conv(App app) {
        NullCheck.notNull((Object)((Object)app), (String)"app");
        this.app = app;
        this.luwrain = app.getLuwrain();
        this.strings = (Strings)app.getStrings();
    }

    File attachment() {
        return Popups.existingFile((Luwrain)this.luwrain, (String)this.strings.attachmentPopupPrefix());
    }

    boolean confirmAttachmentDeleting(File file) {
        NullCheck.notNull((Object)file, (String)"file");
        return Popups.confirmDefaultYes((Luwrain)this.luwrain, (String)"\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043f\u0440\u0438\u043a\u0440\u0435\u043f\u043b\u0435\u043d\u0438\u044f", (String)("\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0438\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u044c " + file.getName() + " \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430 \u043f\u0440\u0438\u043a\u0440\u0435\u043f\u043b\u0435\u043d\u0438\u0439?"));
    }

    String editCc(String initial) {
        CcEditPopup popup;
        NullCheck.notNull((Object)initial, (String)"initial");
        String[] items = App.splitAddrs(initial);
        try {
            popup = new CcEditPopup(this.luwrain, org.luwrain.popups.pim.Strings.create((Luwrain)this.luwrain), this.app.getContactsStoring(), items);
        }
        catch (PimException e) {
            this.luwrain.crash((Throwable)e);
            return null;
        }
        this.luwrain.popup((Popup)popup);
        if (popup.wasCancelled()) {
            return null;
        }
        Object[] newItems = popup.result();
        NullCheck.notNullItems((Object[])newItems, (String)"newItems");
        if (newItems.length == 0) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        b.append((String)newItems[0]);
        for (int i = 1; i < newItems.length; ++i) {
            b.append("," + (String)newItems[i]);
        }
        return b.toString();
    }

    String editTo() {
        ChooseMailPopup popup;
        try {
            popup = new ChooseMailPopup(this.luwrain, org.luwrain.popups.pim.Strings.create((Luwrain)this.luwrain), this.app.getContactsStoring(), this.app.getContactsStoring().getFolders().getRoot());
        }
        catch (PimException e) {
            this.luwrain.crash((Throwable)e);
            return null;
        }
        this.luwrain.popup((Popup)popup);
        if (popup.wasCancelled()) {
            return null;
        }
        return popup.result();
    }

    boolean confirmLaunchingAccountWizard() {
        return Popups.confirmDefaultYes((Luwrain)this.luwrain, (String)"\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f", (String)"\u0423\u0447\u0451\u0442\u043d\u044b\u0435 \u0437\u0430\u043f\u0438\u0441\u0438 \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u043e\u0447\u0442\u044b \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442. \u0412\u044b \u0445\u043e\u0442\u0438\u0442\u0435 \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u0443\u044e \u0441\u0435\u0439\u0447\u0430\u0441?");
    }

    Account accountToSend() throws PimException {
        return null;
    }

    boolean closeModified() {
        return Popups.confirmDefaultNo((Luwrain)this.luwrain, (String)this.strings.closeModifiedPopupName(), (String)this.strings.closeModifiedPopupText());
    }
}

