/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.mail.layouts;

import java.util.Properties;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.mail.App;
import org.luwrain.app.mail.Data;
import org.luwrain.controls.FormArea;
import org.luwrain.core.Area;
import org.luwrain.core.Luwrain;
import org.luwrain.pim.mail.persistence.model.Folder;

public final class FolderPropertiesLayout
extends LayoutBase {
    final Folder folder;
    final Data data;
    final FormArea formArea;

    public FolderPropertiesLayout(App app, Folder folder, LayoutBase.ActionHandler closing) {
        super((AppBase)app);
        this.data = app.getData();
        this.folder = folder;
        this.formArea = new FormArea(this.getControlContext(), "\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u0433\u0440\u0443\u043f\u043f\u044b \"" + folder.getName() + "\"");
        this.formArea.addEdit("title", "\u0418\u043c\u044f \u0433\u0440\u0443\u043f\u043f\u044b:", folder.getName());
        this.formArea.addCheckbox("defaultIncoming", "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0434\u043b\u044f \u0432\u0445\u043e\u0434\u044f\u0449\u0438\u0445 \u043f\u0438\u0441\u0435\u043c \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e:", FolderPropertiesLayout.propSet(folder.getProperties(), "default-incoming"));
        this.formArea.addCheckbox("defaultIncomingLists", "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0434\u043b\u044f \u043f\u0438\u0441\u0435\u043c \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u043e\u0432 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438:", FolderPropertiesLayout.propSet(folder.getProperties(), "default-mailing-lists"));
        this.formArea.addCheckbox("defaultOutgoing", "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0434\u043b\u044f \u0438\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0445 \u043f\u0438\u0441\u0435\u043c:", FolderPropertiesLayout.propSet(folder.getProperties(), "default-outgoing"));
        this.formArea.addCheckbox("defaultSent", "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043f\u0438\u0441\u0435\u043c:", FolderPropertiesLayout.propSet(folder.getProperties(), "default-sent"));
        this.setCloseHandler(closing);
        this.setOkHandler(() -> {
            if (!this.save()) {
                return true;
            }
            return closing.onAction();
        });
        this.setAreaLayout((Area)this.formArea, null);
    }

    private boolean save() {
        String title = this.formArea.getEnteredText("title").trim();
        if (title.isEmpty()) {
            this.app.getLuwrain().message("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c", Luwrain.MessageType.ERROR);
            return false;
        }
        this.folder.setName(title);
        this.folder.getProperties().setProperty("default-incoming", Boolean.valueOf(this.formArea.getCheckboxState("defaultIncoming")).toString());
        this.folder.getProperties().setProperty("default-mailing-lists", Boolean.valueOf(this.formArea.getCheckboxState("defaultIncomingLists")).toString());
        this.folder.getProperties().setProperty("default-outgoing", Boolean.valueOf(this.formArea.getCheckboxState("defaultOutgoing")).toString());
        this.folder.getProperties().setProperty("default-sent", Boolean.valueOf(this.formArea.getCheckboxState("defaultSent")).toString());
        this.data.folderDAO.update(this.folder);
        return true;
    }

    private static boolean propSet(Properties props, String propName) {
        String value = props.getProperty(propName);
        if (value == null) {
            return false;
        }
        return value.equals("true");
    }
}

