/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.linux;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;

class PointerInputListening {
    private static final String LOG_COMPONENT = "linux";
    private static final long DOUBLE_CLICK_DELAY_MSEC = 500L;
    private static final int STEP_X = 30;
    private static final int STEP_Y = 30;
    private final Executor executor = Executors.newSingleThreadExecutor();
    private final Luwrain luwrain;
    private final String fileName;
    private FutureTask task = null;
    private int posX = 0;
    private int posY = 0;
    private long prevTimeMsec = -1L;

    PointerInputListening(Luwrain luwrain, String fileName) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notEmpty((Object)fileName, (String)"fileName");
        this.luwrain = luwrain;
        this.fileName = fileName;
    }

    void run() {
        this.task = this.createTask();
        Log.debug((String)LOG_COMPONENT, (String)("starting pointer input listening on " + this.fileName));
        this.executor.execute(this.task);
    }

    private FutureTask createTask() {
        return new FutureTask<Object>(() -> {
            FilterInputStream s = null;
            try {
                s = new DataInputStream(new FileInputStream("/dev/input/mice"));
                while (true) {
                    int code = ((DataInputStream)s).readUnsignedByte();
                    byte x = ((DataInputStream)s).readByte();
                    byte y = ((DataInputStream)s).readByte();
                    if ((code & 1) > 0) {
                        long currentMsec = System.currentTimeMillis();
                        if (this.prevTimeMsec >= 0L && currentMsec - this.prevTimeMsec <= 500L) {
                            this.luwrain.sendInputEvent(new InputEvent(InputEvent.Special.ENTER));
                        }
                        this.prevTimeMsec = currentMsec;
                    }
                    if ((code & 2) > 0) {
                        this.luwrain.sendInputEvent(new InputEvent(InputEvent.Special.CONTEXT_MENU));
                    }
                    if ((code & 8) <= 0) continue;
                    this.onOffset(x, y);
                }
            }
            catch (Exception e) {
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Log.error((String)LOG_COMPONENT, (String)("unable to get pointer input events:" + e.getClass().getName() + ":" + e.getMessage()));
                return;
            }
        }, null);
    }

    private void onOffset(int x, int y) {
        this.posX += x;
        this.posY += y;
        boolean step = false;
        do {
            step = false;
            while (this.posX > 30) {
                this.luwrain.sendInputEvent(new InputEvent(InputEvent.Special.ARROW_RIGHT));
                this.posX -= 30;
                step = true;
            }
            while (this.posY > 30) {
                this.luwrain.sendInputEvent(new InputEvent(InputEvent.Special.ARROW_UP));
                this.posY -= 30;
                step = true;
            }
            while (this.posX < -30) {
                this.luwrain.sendInputEvent(new InputEvent(InputEvent.Special.ARROW_LEFT));
                this.posX += 30;
                step = true;
            }
            while (this.posY < -30) {
                this.luwrain.sendInputEvent(new InputEvent(InputEvent.Special.ARROW_DOWN));
                this.posY += 30;
                step = true;
            }
        } while (step);
    }
}

