/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.linux;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.util.FileUtils;

public final class BlockDevices {
    private static final Logger log = LogManager.getLogger();
    public static final File SYS_BLOCK = new File("/sys/block");
    public static final File DEV = new File("/dev");

    public String[] getHardDrives() {
        ArrayList<String> res = new ArrayList<String>();
        File[] dev = SYS_BLOCK.listFiles();
        if (dev == null) {
            return new String[0];
        }
        File devDir = new File("/dev");
        for (File f : dev) {
            block5: {
                if (!f.isDirectory()) continue;
                File removable = new File(f, "removable");
                File cap = new File(f, "capability");
                try {
                    Integer capValue;
                    if (new File(f, "loop").exists() || new File(f, "dm").exists() || FileUtils.readTextFileSingleString((File)removable, (String)"UTF-8").trim().equals("1") || ((capValue = Integer.valueOf(Integer.parseInt(FileUtils.readTextFileSingleString((File)cap, (String)"UTF-8").trim(), 16))) & 0x10) == 0) continue;
                    if ((capValue & 0x200) != 0) {
                    }
                    break block5;
                }
                catch (Exception e) {
                    log.trace("Exploring " + f.getAbsolutePath(), (Throwable)e);
                }
                continue;
            }
            res.add(f.getName());
        }
        Object[] r = res.toArray(new String[res.size()]);
        Arrays.sort(r);
        return r;
    }

    public String getDeviceName(String dev) {
        Objects.requireNonNull(dev, "dev can't be null");
        try {
            return FileUtils.readTextFileSingleString((File)new File(new File(SYS_BLOCK, dev), "device/model"), (String)"UTF-8").trim();
        }
        catch (IOException e) {
            log.error("Unable to get the name of the device " + dev, (Throwable)e);
            return "";
        }
    }

    public long getDeviceSize(String dev) {
        Objects.requireNonNull(dev, "dev can't be null");
        try {
            String sizeStr = FileUtils.readTextFileSingleString((File)new File(new File(SYS_BLOCK, dev), "size"), (String)"UTF_8").trim();
            Long l = Long.parseLong(sizeStr);
            return l * 512L;
        }
        catch (IOException e) {
            log.error("Unable to get the name of the device " + dev, (Throwable)e);
            return -1L;
        }
    }
}

