/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.wifi;

import java.util.Set;
import org.luwrain.app.wifi.App;
import org.luwrain.app.wifi.Strings;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Luwrain;
import org.luwrain.core.Sounds;
import org.luwrain.core.Suggestions;
import org.luwrain.linux.WifiNetwork;

final class Appearance
extends ListUtils.AbstractAppearance<WifiNetwork> {
    private final Luwrain luwrain;
    private final Strings strings;

    Appearance(App app) {
        this.luwrain = app.getLuwrain();
        this.strings = (Strings)app.getStrings();
    }

    public void announceItem(WifiNetwork wifi, Set<ListArea.Appearance.Flags> flags) {
        if (wifi.isConnected()) {
            this.luwrain.setEventResponse(DefaultEventResponse.listItem((Sounds)Sounds.SELECTED, (String)wifi.getName(), (Suggestions)Suggestions.CLICKABLE_LIST_ITEM));
        } else if (wifi.getProtectionType() != null && !wifi.getProtectionType().isEmpty()) {
            this.luwrain.setEventResponse(DefaultEventResponse.listItem((Sounds)Sounds.BLOCKED, (String)wifi.getName(), (Suggestions)Suggestions.CLICKABLE_LIST_ITEM));
        } else {
            this.luwrain.setEventResponse(DefaultEventResponse.listItem((String)wifi.toString(), (Suggestions)Suggestions.CLICKABLE_LIST_ITEM));
        }
    }

    public String getScreenAppearance(WifiNetwork wifi, Set<ListArea.Appearance.Flags> flags) {
        return wifi.toString();
    }
}

