/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.term;

import java.util.ArrayList;
import java.util.List;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.HotPoint;
import org.luwrain.core.Lines;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.linux.TermInfo;

final class Terminal
implements Lines,
HotPoint {
    private static final String LOG_COMPONENT = "term";
    private final Luwrain luwrain;
    private final TermInfo termInfo;
    private List<String> lines = new ArrayList<String>();
    private int hotPointX = 0;
    private int hotPointY = 0;
    private StringBuilder seq = new StringBuilder();

    Terminal(Luwrain luwrain, TermInfo termInfo) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)termInfo, (String)"termInfo");
        this.luwrain = luwrain;
        this.termInfo = termInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void termText(String text) {
        if (text.isEmpty()) {
            return;
        }
        if (this.lines.isEmpty()) {
            this.lines.add("");
        }
        StringBuilder speaking = new StringBuilder();
        try {
            block24: for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                this.seq.append(ch);
                String seqStr = new String(this.seq);
                String res = this.termInfo.find(seqStr);
                if (res != null && res.isEmpty()) continue;
                this.seq = new StringBuilder();
                if (res == null) {
                    speaking.append(seqStr);
                    switch (seqStr) {
                        case "\u0007": {
                            break;
                        }
                        case "\b": {
                            this.backspace();
                            break;
                        }
                        case "\r": {
                            break;
                        }
                        case "\n": {
                            this.lines.add("");
                            ++this.hotPointY;
                            this.hotPointX = 0;
                            break;
                        }
                        default: {
                            this.lines.set(this.lines.size() - 1, this.lines.get(this.lines.size() - 1) + seqStr);
                            this.hotPointX += seqStr.length();
                            break;
                        }
                    }
                    continue;
                }
                switch (res) {
                    case "color": 
                    case "el": {
                        continue block24;
                    }
                    case "cr": {
                        this.lines.add("");
                        ++this.hotPointY;
                        this.hotPointX = 0;
                        continue block24;
                    }
                    default: {
                        Log.warning((String)LOG_COMPONENT, (String)("unknown terminal command: '" + res + "'"));
                        continue block24;
                    }
                }
            }
        }
        finally {
            this.speak(new String(speaking));
        }
    }

    private void speak(String text) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\u0007') {
                this.luwrain.playSound(Sounds.TERM_BELL);
                continue;
            }
            if (ch < ' ') {
                str.append(" ");
                continue;
            }
            str.append(ch);
        }
        String toSpeak = new String(str).trim();
        if (toSpeak.isEmpty()) {
            return;
        }
        if (toSpeak.length() == 1) {
            this.luwrain.speakLetter(toSpeak.charAt(0));
        } else {
            this.luwrain.speak(this.luwrain.getSpeakableText(toSpeak, Luwrain.SpeakableTextType.PROGRAMMING));
        }
    }

    public int getHotPointX() {
        return this.hotPointX;
    }

    public int getHotPointY() {
        return this.hotPointY;
    }

    public int getLineCount() {
        return this.lines.size();
    }

    public String getLine(int index) {
        if (index >= this.lines.size()) {
            return "";
        }
        return this.lines.get(index);
    }

    private void backspace() {
        if (this.hotPointY >= this.lines.size()) {
            return;
        }
        String line = this.lines.get(this.hotPointY);
        if (this.hotPointX == 0 || this.hotPointX > line.length()) {
            return;
        }
        char ch = line.charAt(this.hotPointX - 1);
        this.lines.set(this.hotPointY, line.substring(0, this.hotPointX - 1) + line.substring(this.hotPointX));
        --this.hotPointX;
        this.luwrain.setEventResponse(DefaultEventResponse.letter((char)ch));
    }
}

