/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.parted;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.parted.MainLayout;
import org.luwrain.app.parted.Strings;
import org.luwrain.core.Application;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.MonoApp;
import org.luwrain.core.NullCheck;
import org.luwrain.linux.BlockDevices;
import org.luwrain.linux.Parted;

public final class App
extends AppBase<Strings>
implements MonoApp {
    private MainLayout mainLayout = null;
    final List<Parted> disks = new ArrayList<Parted>();
    final List<String> parts = new ArrayList<String>();

    public App() {
        super("luwrain.parted", Strings.class, "luwrain.linux.parted");
    }

    protected AreaLayout onAppInit() {
        this.loadDisks();
        this.mainLayout = new MainLayout(this);
        this.setAppName(((Strings)this.getStrings()).appName());
        return this.mainLayout.getAreaLayout();
    }

    private void loadDisks() {
        BlockDevices blockDevices = new BlockDevices();
        for (String dev : blockDevices.getHardDrives()) {
            File devFile = new File(BlockDevices.DEV, dev);
            this.disks.add(new Parted(devFile.getPath()));
        }
        try {
            for (Parted p : this.disks) {
                p.init();
            }
        }
        catch (IOException e) {
            this.crash(e);
        }
    }

    public boolean onEscape() {
        this.closeApp();
        return true;
    }

    public MonoApp.Result onMonoAppSecondInstance(Application app) {
        NullCheck.notNull((Object)app, (String)"app");
        return MonoApp.Result.BRING_FOREGROUND;
    }
}

