/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.reader;

import java.util.LinkedList;
import java.util.List;
import org.luwrain.core.NullCheck;
import org.luwrain.reader.EmptyLine;
import org.luwrain.reader.ListItem;
import org.luwrain.reader.Node;
import org.luwrain.reader.Paragraph;
import org.luwrain.reader.Run;
import org.luwrain.reader.Section;
import org.luwrain.reader.Table;
import org.luwrain.reader.TableCell;
import org.luwrain.reader.TableRow;
import org.luwrain.reader.TextRun;

public final class NodeBuilder {
    private final List<Node> nodes = new LinkedList<Node>();

    public NodeBuilder addSubnode(Node node) {
        NullCheck.notNull((Object)node, (String)"node");
        this.nodes.add(node);
        return this;
    }

    public void addSubnodes(List<Node> nodes) {
        NullCheck.notNull(nodes, (String)"nodes");
        this.nodes.addAll(nodes);
    }

    public NodeBuilder addSubnodes(Node[] nodes) {
        NullCheck.notNullItems((Object[])nodes, (String)"nodes");
        for (Node n : nodes) {
            this.nodes.add(n);
        }
        return this;
    }

    public Paragraph addParagraph() {
        Paragraph para = new Paragraph();
        this.nodes.add(para);
        return para;
    }

    public Paragraph addParagraph(String text) {
        NullCheck.notNull((Object)text, (String)"text");
        Paragraph p = text.isEmpty() ? new EmptyLine() : new Paragraph(new Run[]{new TextRun(text)});
        this.nodes.add(p);
        return p;
    }

    public Paragraph addEmptyLine() {
        return this.addParagraph("");
    }

    public static Paragraph newParagraph(Run[] runs) {
        NullCheck.notNullItems((Object[])runs, (String)"runs");
        Paragraph p = new Paragraph();
        p.setRuns(runs);
        return p;
    }

    public static Paragraph newParagraph(String text) {
        NullCheck.notNull((Object)text, (String)"text");
        Paragraph p = text.isEmpty() ? new EmptyLine() : new Paragraph(new Run[]{new TextRun(text)});
        return p;
    }

    public Node newRoot() {
        Node node = new Node(Node.Type.ROOT);
        node.setSubnodes(this.nodes.toArray(new Node[this.nodes.size()]));
        return node;
    }

    public Table newTable() {
        Table table = new Table();
        table.setSubnodes(this.nodes.toArray(new Node[this.nodes.size()]));
        return table;
    }

    public TableRow newTableRow() {
        TableRow tableRow = new TableRow();
        tableRow.setSubnodes(this.nodes.toArray(new Node[this.nodes.size()]));
        return tableRow;
    }

    public TableCell newTableCell() {
        TableCell tableCell = new TableCell();
        tableCell.setSubnodes(this.nodes.toArray(new Node[this.nodes.size()]));
        return tableCell;
    }

    public ListItem newListItem() {
        ListItem listItem = new ListItem();
        listItem.setSubnodes(this.nodes.toArray(new Node[this.nodes.size()]));
        return listItem;
    }

    public Node newOrderedList() {
        Node orderedList = new Node(Node.Type.ORDERED_LIST);
        orderedList.setSubnodes(this.nodes.toArray(new Node[this.nodes.size()]));
        return orderedList;
    }

    public Node newUnorderedList() {
        Node unorderedList = new Node(Node.Type.UNORDERED_LIST);
        unorderedList.setSubnodes(this.nodes.toArray(new Node[this.nodes.size()]));
        return unorderedList;
    }

    public Section newSection(int level) {
        if (level < 1) {
            throw new IllegalArgumentException("level (" + level + ") may not be less than 1");
        }
        Section sect = new Section(level);
        sect.setSubnodes(this.nodes.toArray(new Node[this.nodes.size()]));
        return sect;
    }
}

