/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.reader;

import java.util.Arrays;
import org.luwrain.core.NullCheck;
import org.luwrain.reader.Node;
import org.luwrain.reader.Paragraph;
import org.luwrain.reader.Run;

final class Cleaning {
    Cleaning() {
    }

    int prune(Node node) {
        NullCheck.notNull((Object)node, (String)"node");
        if (node instanceof Paragraph) {
            return this.pruneParagraph((Paragraph)node);
        }
        Node[] subnodes = node.getSubnodes();
        int k = 0;
        for (int i = 0; i < subnodes.length; ++i) {
            if (subnodes[i].empty) {
                ++k;
                continue;
            }
            subnodes[i - k] = subnodes[i];
        }
        if (k > 0) {
            subnodes = Arrays.copyOf(subnodes, subnodes.length - k);
        }
        for (Node n : subnodes) {
            k += this.prune(n);
        }
        node.setSubnodes(subnodes);
        return k;
    }

    private int pruneParagraph(Paragraph para) {
        NullCheck.notNull((Object)para, (String)"para");
        Run[] runs = para.getRuns();
        int k = 0;
        for (int i = 0; i < runs.length; ++i) {
            if (runs[i].isEmpty()) {
                ++k;
                continue;
            }
            runs[i - k] = runs[i];
        }
        if (k > 0) {
            para.setRuns(Arrays.copyOf(runs, runs.length - k));
        }
        return k;
    }
}

