/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls.reader.view;

import java.util.LinkedList;
import java.util.List;
import org.luwrain.controls.reader.view.RowPart;
import org.luwrain.controls.reader.view.RowPartsSplitter;
import org.luwrain.controls.reader.view.TextExtractor;
import org.luwrain.core.NullCheck;
import org.luwrain.reader.EmptyLine;
import org.luwrain.reader.Node;
import org.luwrain.reader.Paragraph;
import org.luwrain.reader.Run;

public final class TextExtractorWhole
extends TextExtractor {
    private static final String LOG_COMPONENT = "document";
    private final int width;
    private final List<RowPart> parts = new LinkedList<RowPart>();

    public TextExtractorWhole(int width) {
        if (width < 0) {
            throw new IllegalArgumentException("width (" + width + ") may not be negative");
        }
        this.width = width;
    }

    public void onNode(Node node) {
        NullCheck.notNull((Object)node, (String)"node");
        if (node instanceof EmptyLine) {
            this.addEmptyLine();
            return;
        }
        if (node instanceof Paragraph) {
            this.onParagraph((Paragraph)node);
            this.addEmptyLine();
            return;
        }
        for (Node n : node.getSubnodes()) {
            this.onNode(n);
        }
    }

    private void onParagraph(Paragraph para) {
        NullCheck.notNull((Object)para, (String)"para");
        RowPartsSplitter splitter = new RowPartsSplitter();
        for (Run r : para.getRuns()) {
            String text = r.text();
            NullCheck.notNull((Object)text, (String)"text");
            splitter.onRun(r, text, 0, text.length(), this.width);
        }
        if (splitter.res.isEmpty()) {
            return;
        }
        this.onParagraphLines(splitter.res.toArray(new RowPart[splitter.res.size()]));
    }
}

