/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls.reader.view;

import org.luwrain.core.NullCheck;
import org.luwrain.reader.Run;

class BoundingInfo {
    final Run runFrom;
    final Run runTo;
    final int posFrom;
    final int posTo;

    BoundingInfo(Run runFrom, int posFrom, Run runTo, int posTo) {
        if (runFrom == null && runTo == null) {
            throw new IllegalArgumentException("runFrom and runTo may not be null simultainously");
        }
        if (runFrom != null && posFrom < 0) {
            throw new IllegalArgumentException("posFrom may not be negative");
        }
        if (runTo != null && posTo < 0) {
            throw new IllegalArgumentException("posTo may not be negative");
        }
        if (runFrom == runTo && posTo < posFrom) {
            throw new IllegalArgumentException("posTo (" + posTo + ") may not be less than posFrom (" + posFrom + ") with the same runFrom and runTo");
        }
        this.runFrom = runFrom;
        this.posFrom = posFrom;
        this.runTo = runTo;
        this.posTo = posTo;
    }

    void filter(Run[] runs, Acceptor acceptor) {
        NullCheck.notNullItems((Object[])runs, (String)"runs");
        NullCheck.notNull((Object)acceptor, (String)"acceptor");
        boolean accepting = this.runFrom == null;
        for (Run r : runs) {
            if (accepting) {
                if (r == this.runTo) {
                    acceptor.accept(r, 0, Math.min(r.text().length(), this.posTo));
                    return;
                }
                acceptor.accept(r, 0, r.text().length());
                continue;
            }
            if (r == this.runFrom) {
                if (r == this.runTo) {
                    acceptor.accept(r, this.posFrom, Math.min(r.text().length(), this.posTo));
                    return;
                }
                acceptor.accept(r, this.posFrom, r.text().length());
                accepting = true;
                continue;
            }
            if (r != this.runTo) continue;
            return;
        }
    }

    static interface Acceptor {
        public void accept(Run var1, int var2, int var3);
    }
}

