/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls.reader;

import org.luwrain.core.NullCheck;
import org.luwrain.reader.Paragraph;
import org.luwrain.reader.view.Iterator;

public class SentenceIterator {
    private final Iterator it;
    private int pos;

    public SentenceIterator(Iterator it, int pos) {
        NullCheck.notNull((Object)it, (String)"it");
        this.it = it.clone();
        this.pos = pos;
    }

    public boolean forward(StringBuilder b, String delim) {
        boolean afterSentenceEnd;
        NullCheck.notNull((Object)b, (String)"b");
        NullCheck.notNull((Object)delim, (String)"delim");
        if (this.atRowEnd()) {
            if (!this.skipInitialForward(b, delim)) {
                return false;
            }
            afterSentenceEnd = true;
        } else {
            afterSentenceEnd = false;
        }
        if (this.pos >= this.it.getText().length()) {
            throw new RuntimeException("pos (" + this.pos + ") == row.length (" + this.it.getText().length() + ")");
        }
        do {
            String text = this.it.getText();
            if (!afterSentenceEnd) {
                int nextPos = this.findNextSentenceInString(text, this.pos);
                if (nextPos >= 0 && nextPos < text.length()) {
                    b.append(text.substring(this.pos, nextPos));
                    this.pos = nextPos;
                    return true;
                }
                if (nextPos >= 0) {
                    afterSentenceEnd = true;
                }
                b.append(text.substring(this.pos));
                this.pos = text.length();
                continue;
            }
            if (this.pos != 0) {
                throw new RuntimeException("pos (" + this.pos + ") is not zero");
            }
            while (this.pos < text.length() && Character.isSpaceChar(text.charAt(this.pos))) {
                ++this.pos;
            }
            b.append(text.substring(0, this.pos));
            if (this.pos >= text.length()) continue;
            return true;
        } while (this.moveNextInParagraph(b, delim));
        return true;
    }

    protected boolean skipInitialForward(StringBuilder b, String delim) {
        NullCheck.notNull((Object)b, (String)"b");
        NullCheck.notNull((Object)delim, (String)"delim");
        while (this.it.canMoveNext()) {
            this.it.moveNext();
            b.append(delim);
            if (this.it.getText().isEmpty()) continue;
            this.pos = 0;
            return true;
        }
        this.pos = this.it.getText().length();
        return false;
    }

    protected boolean moveNextInParagraph(StringBuilder b, String delim) {
        NullCheck.notNull((Object)b, (String)"b");
        NullCheck.notNull((Object)delim, (String)"dleim");
        Paragraph p = this.it.getParagraph();
        Iterator i = this.it.clone();
        if (!i.canMoveNext()) {
            return false;
        }
        i.moveNext();
        if (p != i.getParagraph()) {
            return false;
        }
        this.it.moveNext();
        this.pos = 0;
        b.append(delim);
        return true;
    }

    protected int findNextSentenceInString(String text, int posFrom) {
        int pos;
        NullCheck.notNull((Object)text, (String)"text");
        for (pos = posFrom; pos < text.length() && text.charAt(pos) != '.' && text.charAt(pos) != '!' && text.charAt(pos) != '?'; ++pos) {
        }
        if (pos >= text.length()) {
            return -1;
        }
        while (pos < text.length() && (text.charAt(pos) == '.' || text.charAt(pos) == '!' || text.charAt(pos) == '?')) {
            ++pos;
        }
        if (pos >= text.length()) {
            return text.length();
        }
        while (pos < text.length() && Character.isSpace(text.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    public Iterator getIterator() {
        return this.it.clone();
    }

    public int getPos() {
        return this.pos;
    }

    public boolean atRowEnd() {
        return this.pos >= this.it.getText().length();
    }
}

