/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.reader.books;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.IDN;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import org.luwrain.app.reader.ParagraphStyle;
import org.luwrain.app.reader.books.Book;
import org.luwrain.app.reader.books.Utils;
import org.luwrain.core.ContentTypes;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.reader.Document;
import org.luwrain.reader.DocumentBuilder;
import org.luwrain.reader.DocumentBuilderLoader;
import org.luwrain.util.Connections;
import org.luwrain.util.Sha1;

public final class UrlLoader {
    private static final String LOG_COMPONENT = "reader";
    private static final String DEFAULT_CHARSET = "UTF-8";
    private final Luwrain luwrain;
    final URL requestedUrl;
    private String requestedContentType = "";
    private String requestedTagRef = "";
    private String requestedCharset = "";
    private ParagraphStyle requestedTxtParaStyle = ParagraphStyle.EMPTY_LINES;
    private URL responseUrl = null;
    private String responseContentType = "";
    private String responseContentEncoding = "";
    private String selectedContentType = "";
    private String selectedCharset = "";
    private Path tmpFile;

    public UrlLoader(Luwrain luwrain, URL url) throws MalformedURLException {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)url, (String)"url");
        this.luwrain = luwrain;
        this.requestedTagRef = url.getRef();
        this.requestedUrl = new URL(url.getProtocol(), IDN.toASCII(url.getHost()), url.getPort(), url.getFile());
    }

    public void setContentType(String contentType) {
        NullCheck.notEmpty((Object)contentType, (String)"contentType");
        this.requestedContentType = contentType;
    }

    public String getContentType() {
        if (this.selectedContentType != null && !this.selectedContentType.isEmpty()) {
            return this.selectedContentType;
        }
        return this.requestedContentType != null ? this.requestedContentType : "";
    }

    public void setCharset(String charset) {
        NullCheck.notEmpty((Object)charset, (String)"charset");
        this.requestedCharset = charset;
    }

    public String getCharset() {
        if (this.selectedCharset != null && !this.selectedCharset.isEmpty()) {
            return this.selectedCharset;
        }
        return this.requestedCharset != null ? this.requestedCharset : "";
    }

    void setTxtParaStyle(ParagraphStyle paraStyle) {
        NullCheck.notNull((Object)((Object)paraStyle), (String)"paraStyle");
        this.requestedTxtParaStyle = paraStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result load() throws IOException {
        try {
            DocumentBuilder builder;
            Log.debug((String)LOG_COMPONENT, (String)("fetching " + this.requestedUrl.toString()));
            this.fetch();
            String string = this.selectedContentType = this.requestedContentType.isEmpty() ? this.responseContentType : this.requestedContentType;
            if (this.selectedContentType.isEmpty() || ContentTypes.isUnknown((String)this.selectedContentType)) {
                this.selectedContentType = this.luwrain.suggestContentType(this.requestedUrl, ContentTypes.ExpectedType.TEXT);
            }
            if (this.selectedContentType.isEmpty()) {
                throw new IOException("Unable to understand the content type");
            }
            Log.debug((String)LOG_COMPONENT, (String)("selected content type is " + this.selectedContentType));
            this.selectedCharset = Utils.extractCharset(this.selectedContentType);
            if (!this.requestedCharset.isEmpty()) {
                this.selectedCharset = this.requestedCharset;
            }
            if (this.selectedCharset.isEmpty()) {
                this.selectedCharset = DEFAULT_CHARSET;
            }
            if ((builder = new DocumentBuilderLoader().newDocumentBuilder(this.luwrain, Utils.extractBaseContentType(this.selectedContentType))) == null) {
                throw new IOException("No suitable handler for the content type: " + this.selectedContentType);
            }
            Result res = new Result();
            Properties props = new Properties();
            props.setProperty("url", this.responseUrl.toString());
            props.setProperty("charset", this.selectedCharset);
            res.doc = builder.buildDoc(this.tmpFile.toFile(), props);
            if (res.doc == null) {
                throw new IOException("No suitable handler for the content type: " + this.selectedContentType);
            }
            res.doc.setProperty("hash", this.getTmpFileHash());
            res.doc.setProperty("url", this.responseUrl.toString());
            res.doc.setProperty("contenttype", this.selectedContentType);
            if (this.requestedTagRef != null) {
                res.doc.setProperty("startingref", this.requestedTagRef);
            }
            Result result = res;
            return result;
        }
        finally {
            if (this.tmpFile != null) {
                Log.debug((String)LOG_COMPONENT, (String)("deleting temporary file " + this.tmpFile.toString()));
                Files.delete(this.tmpFile);
                this.tmpFile = null;
            }
        }
    }

    private void fetch() throws IOException {
        URLConnection con;
        try {
            con = Connections.connect((URI)this.requestedUrl.toURI(), (long)0L);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        try (InputStream responseStream = con.getInputStream();){
            this.responseUrl = con.getURL();
            if (this.responseUrl == null) {
                this.responseUrl = this.requestedUrl;
            }
            this.responseContentType = con.getContentType();
            if (this.responseContentType == null) {
                this.responseContentType = "";
            }
            this.responseContentEncoding = con.getContentEncoding();
            if (this.responseContentEncoding == null) {
                this.responseContentEncoding = "";
            }
            if (this.responseContentEncoding.toLowerCase().trim().equals("gzip")) {
                this.downloadToTmpFile(new GZIPInputStream(responseStream));
            } else {
                this.downloadToTmpFile(responseStream);
            }
        }
    }

    private void downloadToTmpFile(InputStream s) throws IOException {
        NullCheck.notNull((Object)s, (String)"s");
        this.tmpFile = Files.createTempFile("tmplwr-reader-", ".dat", new FileAttribute[0]);
        Log.debug((String)LOG_COMPONENT, (String)("creating temporary file " + this.tmpFile.toString()));
        Files.copy(s, this.tmpFile, StandardCopyOption.REPLACE_EXISTING);
    }

    private String getTmpFileHash() {
        String string;
        FileInputStream is = new FileInputStream(this.tmpFile.toFile());
        try {
            string = Sha1.getSha1((InputStream)is);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)is).close();
                throw throwable;
            }
            catch (Exception e) {
                Log.error((String)LOG_COMPONENT, (String)("unable to get the hash of the temporary file:" + e.getClass().getName() + ":" + e.getMessage()));
                return "";
            }
        }
        ((InputStream)is).close();
        return string;
    }

    private String makeTitleFromUrl() {
        String path = this.responseUrl.getPath();
        if (path == null || path.isEmpty()) {
            return this.responseUrl.toString();
        }
        int lastSlashPos = path.lastIndexOf("/");
        String fileName = lastSlashPos >= 0 && lastSlashPos + 1 < path.length() ? path.substring(lastSlashPos + 1) : path;
        try {
            return URLDecoder.decode(fileName, DEFAULT_CHARSET);
        }
        catch (IOException e) {
            return fileName;
        }
    }

    public static final class Result {
        public Book book = null;
        public Document doc = null;
    }
}

