/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.reader;

import java.io.File;
import java.net.URL;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Set;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.reader.App;
import org.luwrain.app.reader.BookContainer;
import org.luwrain.app.reader.PropertiesLayout;
import org.luwrain.app.reader.Strings;
import org.luwrain.app.reader.books.Book;
import org.luwrain.controls.CachedTreeModel;
import org.luwrain.controls.CachedTreeModelSource;
import org.luwrain.controls.EditableListArea;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.controls.TreeArea;
import org.luwrain.controls.reader.ReaderArea;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.Suggestions;
import org.luwrain.core.UniRefUtils;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.io.api.books.v1.Note;
import org.luwrain.reader.Document;
import org.luwrain.reader.Run;

final class MainLayout
extends LayoutBase
implements TreeArea.ClickHandler,
ReaderArea.ClickHandler {
    private final App app;
    final TreeArea treeArea;
    final ReaderArea readerArea;
    private final EditableListArea<Note> notesArea;
    private final LayoutBase.Actions treeActions;
    private final LayoutBase.Actions readerActions;
    private final LayoutBase.Actions notesActions;
    private final BookContainer bookContainer;
    private boolean sectionsTreeShown = true;
    private boolean notesShown = false;

    MainLayout(final App app) {
        super((AppBase)app);
        this.app = app;
        this.bookContainer = app.getBookContainer();
        this.sectionsTreeShown = this.bookContainer.getBookFlags().contains((Object)Book.Flags.OPEN_IN_SECTION_TREE);
        LayoutBase.ActionInfo openFile = this.action("open-file", ((Strings)app.getStrings()).actionOpenFile(), new InputEvent(InputEvent.Special.F3, EnumSet.of(InputEvent.Modifiers.SHIFT)), this::actOpenFile);
        LayoutBase.ActionInfo openUrl = this.action("open-url", ((Strings)app.getStrings()).actionOpenUrl(), new InputEvent(InputEvent.Special.F4, EnumSet.of(InputEvent.Modifiers.SHIFT)), this::actOpenUrl);
        LayoutBase.ActionInfo showSectionsTree = this.action("show-sections-tree", ((Strings)app.getStrings()).actionShowSectionsTree(), new InputEvent(InputEvent.Special.F5), this::actShowSectionsTree);
        LayoutBase.ActionInfo showNotes = this.action("show-notes", ((Strings)app.getStrings()).actionShowNotes(), new InputEvent(InputEvent.Special.F6), this::actShowNotes);
        Object params = new TreeArea.Params();
        params.context = this.getControlContext();
        params.model = new CachedTreeModel((CachedTreeModelSource)new BookTreeModelSource());
        params.name = ((Strings)app.getStrings()).treeAreaName();
        params.clickHandler = this;
        this.treeArea = new TreeArea(params);
        this.treeActions = this.actions(new LayoutBase.ActionInfo[]{this.action("hide-sections-tree", ((Strings)app.getStrings()).actionHideSectionsTree(), new InputEvent(InputEvent.Special.F5), this::actHideSectionsTree), showNotes, openFile, openUrl});
        params = new ReaderArea.Params();
        params.context = this.getControlContext();
        params.clickHandler = this;
        this.readerArea = new ReaderArea((ReaderArea.Params)params){

            @Override
            public boolean onInputEvent(InputEvent event) {
                NullCheck.notNull((Object)event, (String)"event");
                if (event.isSpecial() && event.getSpecial() == InputEvent.Special.ESCAPE && !event.isModified() && app.stopAudio()) {
                    return true;
                }
                return super.onInputEvent(event);
            }

            @Override
            public boolean onSystemEvent(SystemEvent event) {
                NullCheck.notNull((Object)event, (String)"events");
                if (event.getType() != SystemEvent.Type.REGULAR) {
                    return super.onSystemEvent(event);
                }
                switch (event.getCode()) {
                    case SAVE: {
                        return MainLayout.this.actSaveBookmark();
                    }
                    case PROPERTIES: {
                        return MainLayout.this.onProps();
                    }
                }
                return super.onSystemEvent(event);
            }

            @Override
            public String getAreaName() {
                Document doc = this.getDocument();
                if (doc == null) {
                    return ((Strings)app.getStrings()).appName();
                }
                return doc.getTitle();
            }

            @Override
            public String getDocUniRef() {
                String addr = this.getDocUrl();
                if (addr.isEmpty()) {
                    return "";
                }
                return UniRefUtils.makeUniRef((String)"reader", (String)addr);
            }

            @Override
            protected String noContentStr() {
                return app.isBusy() ? ((Strings)app.getStrings()).noContentFetching() : ((Strings)app.getStrings()).noContent();
            }
        };
        this.readerActions = this.actions(new LayoutBase.ActionInfo[]{new LayoutBase.ActionInfo((LayoutBase)this, "back", "\u0412\u0435\u0440\u043d\u0443\u0442\u044c\u0441\u044f", new InputEvent(InputEvent.Special.BACKSPACE), this::actBack), new LayoutBase.ActionInfo((LayoutBase)this, "save-bookmark", "\u041f\u043e\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0437\u0430\u043a\u043b\u0430\u0434\u043a\u0443", new InputEvent(InputEvent.Special.F2), this::actSaveBookmark), showSectionsTree, showNotes, openFile, openUrl});
        this.notesArea = new EditableListArea(this.createNotesParams());
        this.notesActions = this.actions(new LayoutBase.ActionInfo[]{this.action("add-note", ((Strings)app.getStrings()).actionAddNote(), new InputEvent(InputEvent.Special.INSERT), this::actAddNote), showSectionsTree, this.action("hide-notes", ((Strings)app.getStrings()).actionHideNotes(), new InputEvent(InputEvent.Special.F6), this::actHideNotes), openFile, openUrl});
        this.updateLayout();
    }

    void updateInitial() {
        this.readerArea.setDocument(this.bookContainer.getDocument(), this.app.getLuwrain().getScreenWidth() - 3);
        if (this.sectionsTreeShown) {
            this.setActiveArea((Area)this.treeArea);
        } else {
            this.setActiveArea(this.readerArea);
        }
    }

    private void updateAfterJump() {
        this.readerArea.setDocument(this.bookContainer.getDocument(), this.app.getLuwrain().getScreenWidth() - 3);
        this.setActiveArea(this.readerArea);
    }

    private boolean actBack() {
        return this.bookContainer.onPrevDoc(() -> this.updateAfterJump());
    }

    private boolean actSaveBookmark() {
        if (!this.bookContainer.notes.setBookmark(this.readerArea.getCurrentRowIndex())) {
            return false;
        }
        this.app.setEventResponse(DefaultEventResponse.text((Sounds)Sounds.OK, (String)"\u0417\u0430\u043a\u043b\u0430\u0434\u043a\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430"));
        return true;
    }

    private boolean actShowSectionsTree() {
        this.sectionsTreeShown = true;
        this.updateLayout();
        this.app.setAreaLayout(this);
        this.setActiveArea((Area)this.treeArea);
        return true;
    }

    private boolean actHideSectionsTree() {
        if (!this.sectionsTreeShown) {
            return false;
        }
        this.sectionsTreeShown = false;
        this.updateLayout();
        this.app.setAreaLayout(this);
        this.setActiveArea(this.readerArea);
        return true;
    }

    private boolean actShowNotes() {
        this.notesShown = true;
        this.updateLayout();
        this.app.setAreaLayout(this);
        this.setActiveArea((Area)this.notesArea);
        return true;
    }

    private boolean actHideNotes() {
        if (!this.notesShown) {
            return false;
        }
        this.notesShown = false;
        this.updateLayout();
        this.app.setAreaLayout(this);
        this.setActiveArea(this.readerArea);
        return true;
    }

    public boolean onTreeClick(TreeArea treeArea, Object obj) {
        NullCheck.notNull((Object)treeArea, (String)"treeArea");
        NullCheck.notNull((Object)obj, (String)"obj");
        if (!(obj instanceof Book.Section)) {
            return false;
        }
        Book.Section sect = (Book.Section)obj;
        return this.bookContainer.jump(sect.href, this.readerArea, 0, () -> this.updateAfterJump());
    }

    @Override
    public boolean onReaderClick(ReaderArea area, Run run) {
        NullCheck.notNull((Object)area, (String)"area");
        NullCheck.notNull((Object)run, (String)"run");
        String href = run.href();
        if (!href.isEmpty()) {
            return this.bookContainer.jump(href, this.readerArea, 0, () -> this.updateAfterJump());
        }
        String[] ids = this.readerArea.getHtmlIds();
        if (ids == null || ids.length == 0) {
            return false;
        }
        return this.app.getBookContainer().playAudio(this.readerArea, ids);
    }

    private boolean actOpenFile() {
        File file = this.app.getConv().fileToOpen();
        return file != null;
    }

    private boolean actOpenUrl() {
        URL url = this.app.getConv().urlToOpen(this.readerArea.getDocUrl());
        if (url == null) {
            return false;
        }
        return false;
    }

    private int getSuitableWidth() {
        return -1;
    }

    private boolean actAddNote() {
        String text = this.app.getConv().newNote();
        if (text == null) {
            return false;
        }
        int selected = this.notesArea.selectedIndex();
        if (selected >= 0) {
            this.app.getBookContainer().notes.addNote(selected, text);
        } else {
            this.app.getBookContainer().notes.addNote(0, text);
        }
        this.notesArea.refresh();
        return true;
    }

    private boolean onProps() {
        PropertiesLayout props = new PropertiesLayout(this.app, () -> {
            this.app.setAreaLayout(this);
            this.setActiveArea(this.readerArea);
            return true;
        });
        this.app.setAreaLayout(props);
        this.app.getLuwrain().announceActiveArea();
        return true;
    }

    private EditableListArea.Params<Note> createNotesParams() {
        EditableListArea.Params params = new EditableListArea.Params();
        params.context = this.getControlContext();
        params.model = this.app.getBookContainer().notes;
        params.appearance = new NotesAppearance();
        params.name = ((Strings)this.app.getStrings()).notesAreaName();
        params.clipboardSaver = (area, model, appearance, fromIndex, toIndex, clipboard) -> true;
        return params;
    }

    void updateLayout() {
        if (this.sectionsTreeShown && this.notesShown) {
            this.setAreaLayout(AreaLayout.LEFT_TOP_BOTTOM, (Area)this.treeArea, this.treeActions, this.readerArea, this.readerActions, (Area)this.notesArea, this.notesActions);
            return;
        }
        if (this.sectionsTreeShown) {
            this.setAreaLayout(AreaLayout.LEFT_RIGHT, (Area)this.treeArea, this.treeActions, this.readerArea, this.readerActions);
            return;
        }
        if (this.notesShown) {
            this.setAreaLayout(AreaLayout.TOP_BOTTOM, this.readerArea, this.readerActions, (Area)this.notesArea, this.notesActions);
            return;
        }
        this.setAreaLayout(this.readerArea, this.readerActions);
    }

    private final class BookTreeModelSource
    implements CachedTreeModelSource {
        private final String root;

        private BookTreeModelSource() {
            this.root = ((Strings)MainLayout.this.app.getStrings()).bookTreeRoot();
        }

        public Object getRoot() {
            return this.root;
        }

        public Object[] getChildObjs(Object obj) {
            LinkedList<Book.Section> res;
            block4: {
                block3: {
                    NullCheck.notNull((Object)obj, (String)"obj");
                    res = new LinkedList<Book.Section>();
                    if (obj != this.root) break block3;
                    for (Book.Section s : MainLayout.this.app.getBookContainer().getSections()) {
                        if (s.level != 1) continue;
                        res.add(s);
                    }
                    break block4;
                }
                Book.Section[] sections = MainLayout.this.app.getBookContainer().getSections();
                int i = 0;
                for (i = 0; i < sections.length && sections[i] != obj; ++i) {
                }
                if (i >= sections.length) break block4;
                Book.Section sect = sections[i];
                for (int k = i + 1; k < sections.length && sections[k].level > sect.level; ++k) {
                    if (sections[k].level != sect.level + 1) continue;
                    res.add(sections[k]);
                }
            }
            return res.toArray(new Object[res.size()]);
        }
    }

    private final class NotesAppearance
    extends ListUtils.AbstractAppearance<Note> {
        private NotesAppearance() {
        }

        public void announceItem(Note note, Set<ListArea.Appearance.Flags> flags) {
            NullCheck.notNull((Object)note, (String)"note");
            NullCheck.notNull(flags, (String)"flags");
            String text = this.getScreenAppearance(note, flags);
            if (note.getType() != null && note.getType().equals("BOOKMARK")) {
                MainLayout.this.app.setEventResponse(DefaultEventResponse.listItem((Sounds)Sounds.SELECTED, (String)text, (Suggestions)Suggestions.LIST_ITEM));
            } else {
                MainLayout.this.app.setEventResponse(DefaultEventResponse.listItem((String)text, (Suggestions)Suggestions.LIST_ITEM));
            }
        }

        public String getScreenAppearance(Note note, Set<ListArea.Appearance.Flags> flags) {
            NullCheck.notNull((Object)note, (String)"note");
            NullCheck.notNull(flags, (String)"flags");
            if (note.getType() != null && note.getType().equals("BOOKMARK")) {
                return "\u0417\u0430\u043a\u043b\u0430\u0434\u043a\u0430 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e";
            }
            return " \u0431\u0435\u0437 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u044f";
        }
    }
}

