/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.reader;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.luwrain.app.reader.LocalRepoMetadata;
import org.luwrain.core.NullCheck;
import org.luwrain.io.api.books.v1.Book;
import org.luwrain.util.FileUtils;
import org.luwrain.util.StreamUtils;

final class LocalRepo {
    private File repoDir;
    private final LocalRepoMetadata metadata;

    LocalRepo(LocalRepoMetadata metadata, File repoDir) {
        NullCheck.notNull((Object)metadata, (String)"metadata");
        NullCheck.notNull((Object)repoDir, (String)"repoDir");
        this.metadata = metadata;
        this.repoDir = repoDir;
    }

    void addDaisy(Book book, File zipFile) throws IOException {
        NullCheck.notNull((Object)book, (String)"book");
        NullCheck.notNull((Object)zipFile, (String)"zipFile");
        String id = book.getId();
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("The book diesn't have an ID");
        }
        File bookDir = new File(this.repoDir, id);
        FileUtils.createSubdirs((File)bookDir);
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(zipFile));){
            ZipInputStream stream = new ZipInputStream(is);
            ZipEntry entry = null;
            while ((entry = stream.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                File destFile = new File(bookDir, entry.getName());
                FileUtils.createSubdirs((File)destFile.getParentFile());
                try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(destFile));){
                    StreamUtils.copyAllBytes((InputStream)stream, (OutputStream)os);
                    os.flush();
                }
                stream.closeEntry();
            }
        }
        this.metadata.addBook(book);
    }

    boolean remove(Book book) {
        NullCheck.notNull((Object)book, (String)"book");
        if (!this.metadata.removeBook(book)) {
            return false;
        }
        this.deleteDir(new File(this.repoDir, book.getId()));
        return true;
    }

    private void deleteDir(File file) {
        NullCheck.notNull((Object)file, (String)"file");
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            file.delete();
            return;
        }
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f == null) continue;
                this.deleteDir(f);
            }
        }
        file.delete();
    }

    File findDaisyMainFile(Book book) {
        NullCheck.notNull((Object)book, (String)"book");
        NullCheck.notEmpty((Object)book.getId(), (String)"book.getId()");
        return this.findNcc(new File(this.repoDir, book.getId()));
    }

    private File findNcc(File file) {
        NullCheck.notNull((Object)file, (String)"file");
        if (!file.isDirectory()) {
            String name = file.getName().toLowerCase();
            return name.equals("ncc.html") || name.equals("ncc.htm") ? file : null;
        }
        File[] files = file.listFiles();
        if (files == null) {
            return null;
        }
        for (File f : files) {
            File res;
            if (f == null || (res = this.findNcc(f)) == null) continue;
            return res;
        }
        return null;
    }

    Book[] getBooks() {
        List<Book> books = this.metadata.getBooks();
        return books.toArray(new Book[books.size()]);
    }

    boolean hasBook(Book book) {
        NullCheck.notNull((Object)book, (String)"book");
        return this.metadata.findBook(book.getId()) != null;
    }
}

