/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.reader;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.TaskCancelling;
import org.luwrain.app.reader.Attributes;
import org.luwrain.app.reader.AudioPlaying;
import org.luwrain.app.reader.BookContainer;
import org.luwrain.app.reader.Conversations;
import org.luwrain.app.reader.ErrorLayout;
import org.luwrain.app.reader.LocalRepo;
import org.luwrain.app.reader.LocalRepoLayout;
import org.luwrain.app.reader.LocalRepoMetadata;
import org.luwrain.app.reader.MainLayout;
import org.luwrain.app.reader.Settings;
import org.luwrain.app.reader.StandaloneSettings;
import org.luwrain.app.reader.Strings;
import org.luwrain.app.reader.books.Book;
import org.luwrain.app.reader.books.BookFactory;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.Standalone;
import org.luwrain.util.Sha1;

public final class App
extends AppBase<Strings> {
    static final String LOG_COMPONENT = "reader";
    private static final String DEFAULT_ENCODING = "UTF-8";
    boolean cancelled = false;
    private final String arg;
    private Conversations conv = null;
    private Settings sett = null;
    private LocalRepoMetadata localRepoMetadata = null;
    private LocalRepo localRepo = null;
    private Attributes attributes = null;
    private AudioPlaying audioPlaying = null;
    private BookContainer bookContainer = null;
    private MainLayout mainLayout = null;
    private LocalRepoLayout localRepoLayout = null;

    public App() {
        this(null);
    }

    public App(String arg) {
        super("luwrain.reader", Strings.class, "luwrain.reader");
        this.arg = arg;
    }

    protected AreaLayout onAppInit() {
        Standalone standalone = new Standalone("lwr-books", "LWRBooks");
        if (standalone.isStandalone()) {
            this.sett = new StandaloneSettings(standalone.getDataDir());
            this.localRepoMetadata = new LocalRepoMetadata(this.sett);
            this.localRepo = new LocalRepo(this.localRepoMetadata, new File(standalone.getDataDir(), "repo"));
        } else {
            this.sett = Settings.create(this.getLuwrain());
            this.localRepoMetadata = new LocalRepoMetadata(this.sett);
            this.localRepo = new LocalRepo(this.localRepoMetadata, new File(this.getLuwrain().getAppDataDir("luwrain.reader").toFile(), "repo"));
        }
        this.attributes = new Attributes(this.sett);
        this.conv = new Conversations(this.getLuwrain(), (Strings)this.getStrings());
        this.audioPlaying = new AudioPlaying(this.getLuwrain());
        if (!this.audioPlaying.isLoaded()) {
            this.audioPlaying = null;
        }
        this.localRepoLayout = new LocalRepoLayout(this);
        this.setAppName(((Strings)this.getStrings()).appName());
        try {
            if (this.arg != null && !this.arg.isEmpty()) {
                this.open(new URI(this.arg));
            }
        }
        catch (URISyntaxException e) {
            this.showErrorLayout(e);
        }
        return this.localRepoLayout.getAreaLayout();
    }

    void open(URI uri) {
        NullCheck.notNull((Object)uri, (String)"uri");
        TaskCancelling.TaskId taskId = this.newTaskId();
        this.runTask(taskId, () -> {
            Book book = new BookFactory().newBook(this.getLuwrain(), uri.toString());
            this.finishedTask(taskId, () -> {
                this.bookContainer = new BookContainer(this, book, Sha1.getSha1((String)uri.toString(), (String)DEFAULT_ENCODING));
                this.mainLayout = new MainLayout(this);
                this.setAreaLayout(this.mainLayout);
                this.mainLayout.updateInitial();
            });
        });
    }

    boolean stopAudio() {
        if (this.audioPlaying == null) {
            return false;
        }
        if (!this.audioPlaying.stop()) {
            return false;
        }
        this.getLuwrain().playSound(Sounds.PLAYING);
        return true;
    }

    public void onException(Throwable e) {
        this.showErrorLayout(e);
    }

    void showErrorLayout(Throwable e) {
        NullCheck.notNull((Object)e, (String)"e");
        ErrorLayout errorLayout = this.mainLayout != null ? new ErrorLayout(this, e, () -> {
            this.setAreaLayout(this.mainLayout);
            this.getLuwrain().announceActiveArea();
            return true;
        }) : new ErrorLayout(this, e, null);
        this.setAreaLayout(errorLayout);
        this.getLuwrain().playSound(Sounds.ERROR);
    }

    public void onCancelledTask() {
        this.cancelled = true;
    }

    public boolean onEscape() {
        this.closeApp();
        return true;
    }

    public void closeApp() {
        if (this.audioPlaying != null) {
            this.audioPlaying.stop();
        }
        super.closeApp();
    }

    public void setAppName(String name) {
        NullCheck.notNull((Object)name, (String)"name");
        super.setAppName(!name.isEmpty() ? name : ((Strings)this.getStrings()).appName());
    }

    Attributes getAttributes() {
        return this.attributes;
    }

    Conversations getConv() {
        return this.conv;
    }

    AudioPlaying getAudioPlaying() {
        return this.audioPlaying;
    }

    BookContainer getBookContainer() {
        return this.bookContainer;
    }

    LocalRepo getLocalRepo() {
        return this.localRepo;
    }

    Layouts layouts() {
        return new Layouts(){

            @Override
            public void localRepo() {
                App.this.setAreaLayout(App.this.localRepoLayout);
                App.this.localRepoLayout.listArea.refresh();
                App.this.getLuwrain().announceActiveArea();
            }
        };
    }

    static interface Layouts {
        public void localRepo();
    }
}

