/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.settings.mail.accounts;

import org.luwrain.controls.ControlContext;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.FormArea;
import org.luwrain.core.Luwrain;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.cpanel.ControlPanel;
import org.luwrain.cpanel.SectionArea;
import org.luwrain.pim.mail.persistence.dao.AccountDAO;
import org.luwrain.pim.mail.persistence.model.Account;
import org.luwrain.settings.mail.Strings;

public final class Area
extends FormArea
implements SectionArea {
    private static final int LEN_LIMIT = 256;
    private static final String TITLE = "title";
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String LOGIN = "login";
    private static final String PASSWD = "passwd";
    private static final String DEFAULT = "default";
    private static final String ENABLED = "enabled";
    final ControlPanel controlPanel;
    final Luwrain luwrain;
    final AccountDAO dao;
    final Account account;
    final Strings strings;

    Area(ControlPanel controlPanel, Strings strings, AccountDAO dao, Account account) {
        super((ControlContext)new DefaultControlContext(controlPanel.getCoreInterface()), strings.accountFormName(), 256);
        this.dao = dao;
        this.strings = strings;
        this.account = account;
        this.controlPanel = controlPanel;
        this.luwrain = controlPanel.getCoreInterface();
        this.fillForm();
    }

    private void fillForm() {
        this.addStatic(this.strings.accountFormServerType() + this.account.getType().toString());
        this.addEdit(TITLE, this.strings.accountFormTitle(), this.account.getName());
        this.addCheckbox(ENABLED, this.strings.accountFormEnabled(), this.account.isEnabled());
        this.addEdit(HOST, this.strings.accountFormHost(), this.account.getHost(), null, true);
        this.addEdit(PORT, this.strings.accountFormPort(), "" + this.account.getPort());
        this.addEdit(LOGIN, this.strings.accountFormLogin(), this.account.getLogin());
        this.addEdit(PASSWD, this.strings.accountFormPasswd(), this.account.getPasswd());
        switch (this.account.getType()) {
            case SMTP: {
                this.addCheckbox(DEFAULT, this.strings.accountFormDefaultOutgoing(), this.account.isDefaultAccount(), null, true);
                this.addCheckbox("tls", this.strings.accountFormUseTls(), this.account.isTls(), null, true);
                this.addEdit("subst-name", this.strings.accountForMessagesAuthorName(), this.account.getSubstName());
                this.addEdit("subst-address", this.strings.accountFormMessagesAuthorAddress(), this.account.getSubstAddress(), null, true);
                break;
            }
            case POP3: {
                this.addEdit("trusted-hosts", this.strings.accountFormTrustedHosts(), this.account.getTrustedHosts(), null, true);
                this.addCheckbox("leave-messages", this.strings.accountFormLeaveMessageOnServer(), this.account.isLeaveMessages(), null, true);
                this.addCheckbox("ssl", this.strings.accountFormUseSsl(), this.account.isSsl(), null, true);
            }
        }
    }

    public boolean saveSectionData() {
        int port;
        try {
            port = Integer.parseInt(this.getEnteredText(PORT));
        }
        catch (NumberFormatException e) {
            this.luwrain.message(this.strings.portNotNumber(), Luwrain.MessageType.ERROR);
            return false;
        }
        if (port <= 0) {
            this.luwrain.message(this.strings.portMustBeGreaterZero(), Luwrain.MessageType.ERROR);
            return false;
        }
        this.account.setName(this.getEnteredText(TITLE));
        this.account.setLogin(this.getEnteredText(LOGIN));
        this.account.setPasswd(this.getEnteredText(PASSWD));
        this.account.setHost(this.getEnteredText(HOST));
        this.account.setPort(port);
        switch (this.account.getType()) {
            case SMTP: {
                this.account.setSubstName(this.getEnteredText("subst-name"));
                this.account.setSubstAddress(this.getEnteredText("subst-address"));
                this.account.setTls(this.getCheckboxState("tls"));
                break;
            }
            case POP3: {
                this.account.setTrustedHosts(this.getEnteredText("trusted-hosts"));
                this.account.setSsl(this.getCheckboxState("ssl"));
                this.account.setLeaveMessages(this.getCheckboxState("leave-messages"));
            }
        }
        this.account.setDefaultAccount(this.getCheckboxState(DEFAULT));
        this.account.setEnabled(this.getCheckboxState(ENABLED));
        this.dao.update(this.account);
        return true;
    }

    public boolean onInputEvent(InputEvent event) {
        if (this.controlPanel.onInputEvent(event)) {
            return true;
        }
        return super.onInputEvent(event);
    }

    public boolean onSystemEvent(SystemEvent event) {
        if (this.controlPanel.onSystemEvent(event)) {
            return true;
        }
        return super.onSystemEvent(event);
    }
}

