/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.settings.mail.accounts;

import org.luwrain.core.Action;
import org.luwrain.core.Luwrain;
import org.luwrain.core.events.ActionEvent;
import org.luwrain.core.events.InputEvent;
import org.luwrain.cpanel.ControlPanel;
import org.luwrain.cpanel.Element;
import org.luwrain.cpanel.Section;
import org.luwrain.cpanel.SectionArea;
import org.luwrain.pim.mail.persistence.MailPersistence;
import org.luwrain.pim.mail.persistence.dao.AccountDAO;
import org.luwrain.settings.mail.accounts.AccountElement;
import org.luwrain.settings.mail.accounts.Accounts;
import org.luwrain.settings.mail.accounts.Area;

public final class AccountSection
implements Section {
    final Luwrain luwrain;
    final Accounts accounts;
    final AccountElement element;
    final String title;
    final int id;

    public AccountSection(Luwrain luwrain, Accounts accounts, AccountElement element) {
        this.luwrain = luwrain;
        this.accounts = accounts;
        this.element = element;
        this.title = element.title;
        this.id = element.id;
    }

    public SectionArea getSectionArea(ControlPanel controlPanel) {
        MailPersistence persist = (MailPersistence)this.luwrain.createInstance(MailPersistence.class);
        Luwrain luwrain = controlPanel.getCoreInterface();
        AccountDAO dao = persist.getAccountDAO();
        return new Area(controlPanel, this.accounts.strings, dao, dao.getById(this.id));
    }

    public Element getElement() {
        return this.element;
    }

    public Action[] getSectionActions() {
        return new Action[]{new Action("add-mail-account", this.accounts.strings.addMailAccount(), new InputEvent(InputEvent.Special.INSERT)), new Action("delete-mail-account", this.accounts.strings.deleteAccount(), new InputEvent(InputEvent.Special.DELETE))};
    }

    public boolean onSectionActionEvent(ControlPanel controlPanel, ActionEvent event) {
        return this.accounts.onActionEvent(controlPanel, event, this.id);
    }

    public String toString() {
        return this.title;
    }
}

