/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.storage;

import java.io.File;
import org.dizitart.no2.Nitrite;
import org.dizitart.no2.objects.ObjectRepository;
import org.luwrain.core.NullCheck;

public final class NitriteStorage<E>
implements AutoCloseable {
    private final File file;
    private final Nitrite db;
    private final ObjectRepository<E> repo;

    public NitriteStorage(File file, Class<E> cl) {
        NullCheck.notNull((Object)file, (String)"file");
        NullCheck.notNull(cl, (String)"cl");
        this.file = file;
        this.db = Nitrite.builder().filePath(file).openOrCreate("luwrain", "passwd");
        this.repo = this.db.getRepository(cl);
    }

    @Override
    public void close() {
        this.db.close();
    }

    public ObjectRepository<E> get() {
        return this.repo;
    }
}

