/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.news.nitrite;

import java.util.UUID;
import org.dizitart.no2.objects.ObjectRepository;
import org.dizitart.no2.objects.filters.ObjectFilters;
import org.luwrain.core.NullCheck;
import org.luwrain.pim.PimException;
import org.luwrain.pim.news.NewsArticle;
import org.luwrain.pim.news.nitrite.Storing;

public final class Article
extends NewsArticle {
    private transient Storing storing;
    private transient ObjectRepository<Article> repo = null;
    String id = null;
    private int groupId;

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    void setStoring(Storing storing, ObjectRepository<Article> repo) {
        NullCheck.notNull((Object)storing, (String)"storing");
        NullCheck.notNull(repo, (String)"repo");
        this.storing = storing;
        this.repo = repo;
    }

    @Override
    public void save() {
        this.verifyStoring();
        try {
            this.storing.execInQueue(() -> {
                this.repo.update(ObjectFilters.eq((String)"id", (Object)this.id), (Object)this);
                return null;
            });
        }
        catch (Exception e) {
            throw new PimException(e);
        }
    }

    protected void verifyStoring() {
        if (this.storing == null || this.repo == null) {
            throw new IllegalStateException("No storing, setStoring() must be called prior to any modification operations");
        }
        if (this.id == null || this.id.isEmpty()) {
            throw new IllegalStateException("No ID");
        }
    }

    public void genNewId() {
        this.id = UUID.randomUUID().toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Article)) {
            return false;
        }
        Article a = (Article)o;
        return this.id.equals(a.id);
    }
}

