/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.mail.script;

import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyExecutable;
import org.luwrain.pim.mail.persistence.model.Folder;
import org.luwrain.pim.mail.script.FolderObj;
import org.luwrain.pim.mail.script.MailObj;
import org.luwrain.script.ScriptUtils;

public final class FoldersObj {
    private final MailObj mailObj;
    @HostAccess.Export
    public final ProxyExecutable findFirstByProperty = this::findFirstByPropertyImpl;
    @HostAccess.Export
    public final ProxyExecutable getDefaultIncoming = this::getDefaultIncomingImpl;
    @HostAccess.Export
    public final ProxyExecutable getDefaultMailingLists = this::getDefaultMailingListsImpl;

    FoldersObj(MailObj mailObj) {
        this.mailObj = mailObj;
    }

    private Object findFirstByPropertyImpl(Value[] args) {
        if (!ScriptUtils.notNullAndLen((Value[])args, (int)2)) {
            return null;
        }
        String name = ScriptUtils.asString((Object)args[0]);
        String value = ScriptUtils.asString((Object)args[1]);
        if (name == null || value == null || name.trim().isEmpty()) {
            return null;
        }
        Folder res = this.mailObj.folderDAO.findFirstByProperty(name, value);
        return res != null ? new FolderObj(this.mailObj, res) : null;
    }

    private Object getDefaultIncomingImpl(Value[] args) {
        Folder f = this.mailObj.folderDAO.findFirstByProperty("default-incoming", "true");
        return f != null ? new FolderObj(this.mailObj, f) : null;
    }

    private Object getDefaultMailingListsImpl(Value[] args) {
        Folder f = this.mailObj.folderDAO.findFirstByProperty("default-mailing-lists", "true");
        return f != null ? new FolderObj(this.mailObj, f) : null;
    }
}

