/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.fetching;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.pim.PimException;
import org.luwrain.pim.fetching.Base;
import org.luwrain.pim.fetching.Control;
import org.luwrain.pim.fetching.FeedUtils;
import org.luwrain.pim.fetching.Strings;
import org.luwrain.pim.news.NewsArticle;
import org.luwrain.pim.news.NewsGroup;
import org.luwrain.pim.news.NewsStoring;

public final class News
extends Base {
    private final NewsStoring storing = null;

    public News(Control control, Strings strings) {
        super(control, strings);
    }

    public void fetch() throws InterruptedException {
        if (this.storing == null) {
            this.message(this.strings.noNewsGroupsData());
            return;
        }
        NewsGroup[] groups = this.storing.getGroups().load();
        if (groups == null || groups.length < 1) {
            this.message(this.strings.noNewsGroups());
            return;
        }
        for (NewsGroup g : groups) {
            this.removeOldArticles(g);
            this.checkInterrupted();
            if (!this.fetchGroup(g)) {
                return;
            }
            this.checkInterrupted();
        }
    }

    boolean fetchGroup(NewsGroup group) throws InterruptedException {
        ArrayList<NewsArticle> freshNews = new ArrayList<NewsArticle>();
        int totalCount = 0;
        List<String> urls = group.getUrls();
        if (urls != null) {
            for (String url : urls) {
                if (url == null || url.trim().isEmpty()) continue;
                this.checkInterrupted();
                NewsArticle[] articles = null;
                try {
                    articles = FeedUtils.readFeed(new URL(url.trim()));
                }
                catch (MalformedURLException | PimException e) {
                    this.message(this.strings.newsFetchingError(group.getName()) + ":" + e.getMessage());
                    return true;
                }
                totalCount += articles.length;
                for (NewsArticle a : articles) {
                    if (this.storing.getArticles().countByUriInGroup(group, a.getUri()) != 0) continue;
                    freshNews.add(a);
                }
            }
        }
        for (NewsArticle a : freshNews) {
            this.storing.getArticles().save(group, a);
            this.checkInterrupted();
        }
        if (freshNews.size() > 0) {
            this.message(group.getName() + ": " + freshNews.size() + "/" + totalCount);
        }
        this.luwrain.sendBroadcastEvent(new SystemEvent(SystemEvent.Type.BROADCAST, SystemEvent.Code.REFRESH, "", "newsgroup:"));
        return true;
    }

    void removeOldArticles(NewsGroup group) {
        NewsArticle[] articles;
        for (NewsArticle a : articles = this.storing.getArticles().load(group)) {
            if (!this.isOldArticle(a)) continue;
            this.storing.getArticles().delete(group, a);
        }
    }

    boolean isOldArticle(NewsArticle article) {
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        Date result = cal.getTime();
        return article.getPublishedDate().compareTo(result) < 0;
    }
}

