/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.fetching;

import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.pim.fetching.Control;
import org.luwrain.pim.fetching.MailConnections;
import org.luwrain.pim.fetching.Strings;
import org.luwrain.pim.mail.persistence.model.Account;

public class Base {
    static final String LOG_COMPONENT = "pim";
    protected final Control control;
    protected final Luwrain luwrain;
    protected final Strings strings;

    public Base(Control control, Strings strings) {
        NullCheck.notNull((Object)control, (String)"control");
        NullCheck.notNull((Object)strings, (String)"strings");
        this.control = control;
        this.strings = strings;
        this.luwrain = control.luwrain();
    }

    protected void message(String text) {
        NullCheck.notNull((Object)text, (String)"text");
        this.control.message(text);
    }

    protected void checkInterrupted() throws InterruptedException {
        this.control.checkInterrupted();
    }

    protected void crash(Exception e) {
        NullCheck.notNull((Object)e, (String)"e");
        this.luwrain.crash((Throwable)e);
    }

    protected MailConnections.Params createMailServerParams(Account account) {
        MailConnections.Params params = new MailConnections.Params();
        params.doAuth = !account.getLogin().isEmpty();
        params.host = account.getHost();
        params.port = account.getPort();
        params.ssl = account.isSsl();
        params.tls = account.isTls();
        params.login = account.getLogin();
        params.passwd = account.getPasswd();
        params.extProps.put("mail.pop3.ssl.trust", account.getTrustedHosts());
        return params;
    }
}

