/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.contacts.json;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;
import org.luwrain.pim.contacts.ContactsFolders;
import org.luwrain.pim.contacts.ContactsStoring;
import org.luwrain.pim.contacts.json.Contacts;
import org.luwrain.pim.contacts.json.Folder;
import org.luwrain.pim.contacts.json.Folders;

public final class Storing
implements ContactsStoring {
    private static final String LOG_COMPONENT = "pim-contacts";
    private final Gson gson = new Gson();
    private final File file;
    Folder root = new Folder();
    private final Folders folders;
    private final Contacts contacts;

    public Storing(File file) {
        NullCheck.notNull((Object)file, (String)"file");
        this.file = file;
        this.folders = new Folders(this);
        this.contacts = new Contacts(this);
        Folder f = null;
        try (BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            f = (Folder)this.gson.fromJson((Reader)r, Folder.class);
        }
        catch (IOException e) {
            Log.debug((String)LOG_COMPONENT, (String)("unable to read " + file.getAbsolutePath() + ": " + e.getClass().getName() + ": " + e.getMessage() + ", probably the first start"));
        }
        this.root = f != null ? f : new Folder();
        this.root.setStoring(this);
    }

    void save() {
        try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.file)));){
            this.gson.toJson((Object)this.root, (Appendable)w);
            w.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ContactsFolders getFolders() {
        return this.folders;
    }

    @Override
    public Contacts getContacts() {
        return this.contacts;
    }
}

