/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import org.luwrain.core.NullCheck;

public final class ExecQueues
implements Runnable {
    private final ConcurrentLinkedQueue<FutureTask> lowPriorityQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<FutureTask> highPriorityQueue = new ConcurrentLinkedQueue();
    private final Object syncObj = new Object();
    private final Executor executor = Executors.newSingleThreadExecutor();
    private Thread thread = null;
    private volatile boolean cancelling = false;

    public void enqueue(FutureTask task, boolean highPriority) {
        NullCheck.notNull((Object)task, (String)"task");
        if (highPriority) {
            this.enqueueHighPriority(task);
        } else {
            this.enqueueLowPriority(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueHighPriority(FutureTask task) {
        NullCheck.notNull((Object)task, (String)"task");
        Object object = this.syncObj;
        synchronized (object) {
            this.highPriorityQueue.add(task);
            this.syncObj.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueLowPriority(FutureTask task) {
        NullCheck.notNull((Object)task, (String)"task");
        Object object = this.syncObj;
        synchronized (object) {
            this.lowPriorityQueue.add(task);
            this.syncObj.notifyAll();
        }
    }

    public <T> T exec(FutureTask<T> task, boolean highPriority) throws Exception {
        NullCheck.notNull(task, (String)"task");
        if (highPriority) {
            return this.execHighPriority(task);
        }
        return this.execLowPriority(task);
    }

    public <T> T execHighPriority(FutureTask<T> task) throws Exception {
        NullCheck.notNull(task, (String)"task");
        this.enqueueHighPriority(task);
        try {
            return task.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public <T> T execLowPriority(FutureTask<T> task) throws Exception {
        NullCheck.notNull(task, (String)"task");
        this.enqueueLowPriority(task);
        try {
            return task.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public void start() {
        if (this.thread != null) {
            throw new RuntimeException("Thread is already started");
        }
        this.cancelling = false;
        this.thread = new Thread(this);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.syncObj;
        synchronized (object) {
            this.cancelling = true;
            this.syncObj.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block5: while (true) {
            Object object = this.syncObj;
            synchronized (object) {
                try {
                    while (this.highPriorityQueue.isEmpty() && this.lowPriorityQueue.isEmpty() && !this.cancelling) {
                        this.syncObj.wait();
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            if (this.cancelling) {
                return;
            }
            if (this.cancelling) {
                return;
            }
            while (true) {
                FutureTask task;
                if (this.highPriorityQueue.isEmpty() && this.lowPriorityQueue.isEmpty()) continue block5;
                if (this.cancelling) {
                    return;
                }
                while (!this.highPriorityQueue.isEmpty()) {
                    task = this.highPriorityQueue.poll();
                    this.executor.execute(task);
                }
                if (this.lowPriorityQueue.isEmpty()) continue;
                task = this.lowPriorityQueue.poll();
                this.executor.execute(task);
            }
            break;
        }
    }
}

