/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.man;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.man.App;
import org.luwrain.app.man.Strings;
import org.luwrain.controls.ConsoleArea;
import org.luwrain.controls.ConsoleUtils;
import org.luwrain.controls.SimpleArea;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Luwrain;
import org.luwrain.core.Sounds;
import org.luwrain.core.Suggestions;
import org.luwrain.linux.BashProcess;

final class MainLayout
extends LayoutBase
implements ConsoleArea.ClickHandler<String>,
ConsoleArea.InputHandler {
    private static final Logger log = LogManager.getLogger();
    private static final Pattern ENTRY_PATTERN = Pattern.compile("^([a-zA-Z0-9_-]+)\\s+\\(([0-9a-zA-Z_-]+)\\)\\s.*$", 2);
    private final App app;
    private final ConsoleArea<String> searchArea;
    private final SimpleArea pageArea;
    private String[] pages = new String[0];

    MainLayout(App app) {
        super((AppBase)app);
        this.app = app;
        this.searchArea = new ConsoleArea(this.consoleParams(params -> {
            params.model = new ConsoleUtils.ArrayModel(() -> this.pages);
            params.appearance = new SearchAreaAppearance();
            params.name = ((Strings)app.getStrings()).searchAreaName();
            params.inputPos = ConsoleArea.InputPos.TOP;
            params.inputPrefix = "man>";
            params.inputHandler = this;
            params.clickHandler = this;
        }));
        this.pageArea = new SimpleArea(this.getControlContext(), ((Strings)app.getStrings()).pageAreaName());
        this.setAreaLayout(AreaLayout.TOP_BOTTOM, (Area)this.searchArea, null, (Area)this.pageArea, null);
    }

    public boolean onConsoleClick(ConsoleArea area, int index, String item) {
        Matcher m = ENTRY_PATTERN.matcher(item.trim());
        if (!m.find()) {
            return false;
        }
        BashProcess p = new BashProcess("man " + BashProcess.escape((String)m.group(2)) + " " + BashProcess.escape((String)m.group(1)));
        try {
            p.run();
        }
        catch (IOException e) {
            this.app.crash(e);
            return true;
        }
        int exitCode = p.waitFor();
        if (exitCode != 0) {
            this.app.getLuwrain().playSound(Sounds.ERROR);
            for (String s : p.getErrors()) {
                log.error("Man: " + s);
            }
            return true;
        }
        this.pageArea.setLines(p.getOutput());
        this.pageArea.setHotPoint(0, 0);
        this.setActiveArea((Area)this.pageArea);
        return true;
    }

    public ConsoleArea.InputHandler.Result onConsoleInput(ConsoleArea area, String text) {
        if (text.trim().isEmpty()) {
            return ConsoleArea.InputHandler.Result.REJECTED;
        }
        if (!this.search(text.trim().toLowerCase())) {
            return ConsoleArea.InputHandler.Result.REJECTED;
        }
        area.refresh();
        return ConsoleArea.InputHandler.Result.OK;
    }

    boolean search(String query) {
        BashProcess p = new BashProcess("man -k " + BashProcess.escape((String)query.trim()));
        try {
            p.run();
        }
        catch (IOException e) {
            this.app.getLuwrain().crash((Throwable)e);
            return true;
        }
        int exitCode = p.waitFor();
        if (exitCode != 0) {
            String[] errors = p.getErrors();
            if (errors.length > 0) {
                this.app.getLuwrain().message(errors[0], Luwrain.MessageType.ERROR);
            } else {
                this.app.getLuwrain().playSound(Sounds.ERROR);
            }
            return true;
        }
        this.app.getLuwrain().playSound(Sounds.OK);
        this.pages = p.getOutput();
        return true;
    }

    private final class SearchAreaAppearance
    implements ConsoleArea.Appearance<String> {
        private SearchAreaAppearance() {
        }

        public void announceItem(String item) {
            MainLayout.this.app.setEventResponse(DefaultEventResponse.listItem((String)MainLayout.this.app.getLuwrain().getSpeakableText(item, Luwrain.SpeakableTextType.PROGRAMMING), (Suggestions)Suggestions.CLICKABLE_LIST_ITEM));
        }

        public String getTextAppearance(String item) {
            return item;
        }
    }
}

