/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.opds;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.opds.App;
import org.luwrain.app.opds.Appearance;
import org.luwrain.app.opds.LibraryPropsLayout;
import org.luwrain.app.opds.Opds;
import org.luwrain.app.opds.PropertiesItem;
import org.luwrain.app.opds.RemoteLibrary;
import org.luwrain.app.opds.Strings;
import org.luwrain.app.opds.Utils;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Suggestions;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;

final class MainLayout
extends LayoutBase {
    private final App app;
    final ListArea librariesArea;
    final ListArea<Opds.Entry> listArea;
    final ListArea detailsArea;

    MainLayout(App app) {
        super((AppBase)app);
        this.app = app;
        this.librariesArea = new ListArea(this.listParams(params -> {
            params.model = new ListUtils.ListModel(app.libraries);
            params.appearance = new ListUtils.DefaultAppearance(this.getControlContext());
            params.clickHandler = (area, index, obj) -> this.onLibraryClick(obj);
            params.name = ((Strings)app.getStrings()).librariesAreaName();
        })){

            public boolean onSystemEvent(SystemEvent event) {
                NullCheck.notNull((Object)event, (String)"event");
                if (event.getType() != SystemEvent.Type.REGULAR) {
                    return super.onSystemEvent(event);
                }
                switch (event.getCode()) {
                    case PROPERTIES: {
                        return MainLayout.this.editLibraryProps();
                    }
                }
                return super.onSystemEvent(event);
            }
        };
        LayoutBase.Actions librariesActions = this.actions(new LayoutBase.ActionInfo[]{this.action("new-library", "\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u043d\u043e\u0432\u0443\u044e \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0443", new InputEvent(InputEvent.Special.INSERT), this::actNewLibrary)});
        this.listArea = new ListArea(this.listParams(params -> {
            params.model = new ListUtils.ListModel(app.entries);
            params.appearance = new Appearance(this.getLuwrain(), (Strings)app.getStrings());
            params.clickHandler = (area, index, entry) -> this.onListClick((Opds.Entry)entry);
            params.name = ((Strings)app.getStrings()).itemsAreaName();
        }));
        LayoutBase.Actions listActions = this.actions(new LayoutBase.ActionInfo[0]);
        this.detailsArea = new ListArea(this.listParams(params -> {
            params.model = new ListUtils.FixedModel();
            params.appearance = new ListUtils.DefaultAppearance(this.getControlContext(), Suggestions.CLICKABLE_LIST_ITEM);
            params.name = ((Strings)app.getStrings()).detailsAreaName();
        }));
        LayoutBase.Actions detailsActions = this.actions(new LayoutBase.ActionInfo[0]);
        this.setAreaLayout(AreaLayout.LEFT_TOP_BOTTOM, (Area)this.librariesArea, librariesActions, (Area)this.listArea, listActions, (Area)this.detailsArea, detailsActions);
    }

    private boolean actNewLibrary() {
        String name = this.app.getConv().newLibraryName();
        if (name == null || name.trim().isEmpty()) {
            return true;
        }
        RemoteLibrary r = new RemoteLibrary();
        r.title = name.trim();
        r.url = "https://";
        this.app.libraries.add(r);
        this.app.saveLibraries();
        return true;
    }

    private boolean editLibraryProps() {
        Object obj = this.librariesArea.selected();
        if (obj == null || !(obj instanceof RemoteLibrary)) {
            return false;
        }
        RemoteLibrary lib = (RemoteLibrary)obj;
        LibraryPropsLayout propsLayout = new LibraryPropsLayout(this.app, lib, () -> {
            this.app.setAreaLayout(this);
            this.listArea.refresh();
            this.getLuwrain().announceActiveArea();
        });
        this.app.setAreaLayout(propsLayout);
        this.getLuwrain().announceActiveArea();
        return true;
    }

    private boolean onLibraryClick(Object obj) {
        NullCheck.notNull((Object)obj, (String)"obj");
        if (!(obj instanceof RemoteLibrary)) {
            return false;
        }
        RemoteLibrary library = (RemoteLibrary)obj;
        return this.app.open(MainLayout.url(library.url));
    }

    private boolean onListClick(Opds.Entry entry) {
        NullCheck.notNull((Object)entry, (String)"entry");
        this.onEntry(entry);
        this.listArea.refresh();
        return true;
    }

    private boolean onListProperties(ListArea detailsArea, Object obj) {
        NullCheck.notNull((Object)detailsArea, (String)"detailsArea");
        if (obj == null || !(obj instanceof Opds.Entry)) {
            return false;
        }
        Opds.Entry entry = (Opds.Entry)obj;
        LinkedList<PropertiesItem> items = new LinkedList<PropertiesItem>();
        for (Opds.Link l : entry.links) {
            URL url = this.prepareUrl(l.url);
            if (url == null) continue;
            items.add(new PropertiesItem(url.toString(), l.type));
        }
        ListUtils.FixedModel model = (ListUtils.FixedModel)detailsArea.getListModel();
        model.setItems((Object[])items.toArray(new PropertiesItem[items.size()]));
        this.setActiveArea((Area)detailsArea);
        return true;
    }

    private boolean onLinkClick(Object obj) {
        if (obj == null || !(obj instanceof PropertiesItem)) {
            return false;
        }
        PropertiesItem item = (PropertiesItem)obj;
        this.launchReader(item.url, item.contentType);
        return true;
    }

    private boolean onEntry(Opds.Entry entry) {
        NullCheck.notNull((Object)entry, (String)"entry");
        if (this.openBook(entry)) {
            return true;
        }
        Opds.Link catalogLink = Utils.getCatalogLink(entry);
        if (catalogLink == null) {
            return false;
        }
        if (!this.app.history.isEmpty()) {
            this.app.history.getLast().selected = entry;
            return this.app.open(MainLayout.url(this.app.history.getLast().url, catalogLink.url));
        }
        return this.app.open(MainLayout.url(catalogLink.url));
    }

    private boolean openBook(Opds.Entry entry) {
        NullCheck.notNull((Object)entry, (String)"entry");
        Opds.Link link = this.getSuitableBookLink(entry);
        if (link == null) {
            return false;
        }
        this.launchReader(this.prepareUrl(link.url).toString(), link.type);
        return true;
    }

    private Opds.Link getSuitableBookLink(Opds.Entry entry) {
        NullCheck.notNull((Object)entry, (String)"entry");
        for (Opds.Link link : entry.links) {
            if (!link.type.toLowerCase().equals("application/fb2+zip")) continue;
            return link;
        }
        return null;
    }

    private URL prepareUrl(String href) {
        URL currentUrl = this.app.opened();
        NullCheck.notNull((Object)currentUrl, (String)"currentUrl");
        return MainLayout.url(currentUrl, href);
    }

    private void launchReader(String url, String contentType) {
        NullCheck.notEmpty((Object)url, (String)"url");
        NullCheck.notNull((Object)contentType, (String)"contentType");
        this.getLuwrain().launchApp("reader", new String[]{url, contentType});
    }

    private Opds.Entry returnBack() {
        if (this.app.history.size() <= 1) {
            return null;
        }
        this.app.history.pollLast();
        return this.app.history.getLast().selected;
    }

    private static URL url(String u) {
        NullCheck.notNull((Object)u, (String)"u");
        try {
            return new URL(u);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static URL url(URL baseUrl, String addr) {
        NullCheck.notNull((Object)baseUrl, (String)"baseUrl");
        NullCheck.notNull((Object)addr, (String)"addr");
        try {
            return new URL(baseUrl, addr);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

