/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.tagging.Tagger;
import org.languagetool.tools.StringTools;

public abstract class AbstractFindSuggestionsFilter
extends RuleFilter {
    private final int MAX_SUGGESTIONS = 10;

    protected abstract Tagger getTagger();

    protected abstract List<String> getSpellingSuggestions(String var1) throws IOException;

    @Override
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens) throws IOException {
        ArrayList<String> replacements = new ArrayList<String>();
        String wordFrom = this.getRequired("wordFrom", arguments);
        String desiredPostag = this.getRequired("desiredPostag", arguments);
        String removeSuggestionsRegexp = this.getOptional("removeSuggestionsRegexp", arguments);
        String mode = this.getOptional("Mode", arguments);
        boolean diacriticsMode = mode != null && mode.equals("diacritics");
        boolean generateSuggestions = true;
        Pattern regexpPattern = null;
        if (wordFrom != null && desiredPostag != null) {
            int posWord;
            if (wordFrom.equals("marker")) {
                for (posWord = 0; posWord < patternTokens.length && patternTokens[posWord].getStartPos() < match.getFromPos(); ++posWord) {
                }
                ++posWord;
            } else {
                posWord = Integer.parseInt(wordFrom);
            }
            if (posWord < 1 || posWord > patternTokens.length) {
                throw new IllegalArgumentException("FindSuggestionsFilter: Index out of bounds in " + match.getRule().getFullId() + ", PronounFrom: " + posWord);
            }
            AnalyzedTokenReadings atrWord = patternTokens[posWord - 1];
            boolean isWordCapitalized = StringTools.isCapitalizedWord(atrWord.getToken());
            boolean isWordAllupper = StringTools.isAllUppercase(atrWord.getToken());
            List<String> originalWord = Collections.singletonList(atrWord.getToken());
            List<AnalyzedTokenReadings> aOriginalWord = this.getTagger().tag(originalWord);
            for (AnalyzedTokenReadings atr : aOriginalWord) {
                if (!atr.matchesPosTagRegex(desiredPostag)) continue;
                if (diacriticsMode) {
                    return null;
                }
                generateSuggestions = false;
            }
            if (generateSuggestions) {
                List<String> suggestions;
                if (removeSuggestionsRegexp != null) {
                    regexpPattern = Pattern.compile(removeSuggestionsRegexp, 66);
                }
                String wordToCheck = atrWord.getToken();
                if (atrWord.isTagged()) {
                    wordToCheck = this.makeWrong(atrWord.getToken());
                }
                if ((suggestions = this.getSpellingSuggestions(wordToCheck)).size() > 0) {
                    block2: for (String suggestion : suggestions) {
                        List<AnalyzedTokenReadings> analyzedSuggestions = this.getTagger().tag(Collections.singletonList(this.cleanSuggestion(suggestion)));
                        for (AnalyzedTokenReadings analyzedSuggestion : analyzedSuggestions) {
                            if (replacements.size() >= 10) continue block2;
                            if (suggestion.equals(atrWord.getToken()) || !analyzedSuggestion.matchesPosTagRegex(desiredPostag) || replacements.contains(suggestion) || replacements.contains(suggestion.toLowerCase()) || diacriticsMode && !this.equalWithoutDiacritics(suggestion, atrWord.getToken()) || regexpPattern != null && regexpPattern.matcher(suggestion).matches()) continue;
                            String replacement = suggestion;
                            if (isWordAllupper) {
                                replacement = replacement.toUpperCase();
                            }
                            if (isWordCapitalized) {
                                replacement = StringTools.uppercaseFirstChar(replacement);
                            }
                            replacements.add(replacement);
                        }
                    }
                }
            }
        }
        if (diacriticsMode && replacements.size() == 0) {
            return null;
        }
        String message = match.getMessage();
        RuleMatch ruleMatch = new RuleMatch(match.getRule(), match.getSentence(), match.getFromPos(), match.getToPos(), message, match.getShortMessage());
        ruleMatch.setType(match.getType());
        ArrayList<String> definitiveReplacements = new ArrayList<String>();
        boolean replacementsUsed = false;
        if (generateSuggestions) {
            block4: for (String s : match.getSuggestedReplacements()) {
                if (s.contains("{suggestion}")) {
                    replacementsUsed = true;
                    for (String s2 : replacements) {
                        if (definitiveReplacements.size() >= 10) continue block4;
                        definitiveReplacements.add(s.replace("{suggestion}", s2));
                    }
                    continue;
                }
                definitiveReplacements.add(s);
            }
            if (!replacementsUsed) {
                definitiveReplacements.addAll(replacements);
            }
        }
        if (!definitiveReplacements.isEmpty()) {
            ruleMatch.setSuggestedReplacements(definitiveReplacements);
        }
        return ruleMatch;
    }

    private String makeWrong(String s) {
        if (s.contains("a")) {
            return s.replace("a", "\u00e4");
        }
        if (s.contains("e")) {
            return s.replace("e", "\u00eb");
        }
        if (s.contains("i")) {
            return s.replace("i", "\u00ef");
        }
        if (s.contains("o")) {
            return s.replace("o", "\u00f6");
        }
        if (s.contains("u")) {
            return s.replace("u", "\u00f9");
        }
        if (s.contains("\u00e1")) {
            return s.replace("\u00e1", "\u00e4");
        }
        if (s.contains("\u00e9")) {
            return s.replace("\u00e9", "\u00eb");
        }
        if (s.contains("\u00ed")) {
            return s.replace("\u00ed", "\u00ef");
        }
        if (s.contains("\u00f3")) {
            return s.replace("\u00f3", "\u00f6");
        }
        if (s.contains("\u00fa")) {
            return s.replace("\u00fa", "\u00f9");
        }
        if (s.contains("\u00e0")) {
            return s.replace("\u00e0", "\u00e4");
        }
        if (s.contains("\u00e8")) {
            return s.replace("\u00e8", "\u00eb");
        }
        if (s.contains("\u00ec")) {
            return s.replace("\u00ec", "i");
        }
        if (s.contains("\u00f2")) {
            return s.replace("\u00f2", "\u00f6");
        }
        if (s.contains("\u00ef")) {
            return s.replace("\u00ef", "\u00ec");
        }
        if (s.contains("\u00fc")) {
            return s.replace("\u00fc", "\u00f9");
        }
        return s + "-";
    }

    private boolean equalWithoutDiacritics(String s, String t) {
        return StringTools.removeDiacritics(s).equalsIgnoreCase(StringTools.removeDiacritics(t));
    }

    protected String cleanSuggestion(String s) {
        return s;
    }
}

