/*
 * Decompiled with CFR 0.152.
 */
package com.github.kklisura.cdt.services.utils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javassist.Modifier;
import javassist.util.proxy.ProxyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProxyUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyUtils.class);

    private ProxyUtils() {
    }

    public static <T> T createProxy(Class<T> clazz, InvocationHandler invocationHandler) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, invocationHandler);
    }

    public static <T> T createProxyFromAbstract(Class<T> clazz, Class[] paramTypes, Object[] args, InvocationHandler invocationHandler) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setSuperclass(clazz);
        proxyFactory.setFilter(method -> Modifier.isAbstract((int)method.getModifiers()));
        try {
            return (T)proxyFactory.create(paramTypes, args, (o, method, method1, objects) -> invocationHandler.invoke(o, method, objects));
        }
        catch (Exception e) {
            LOGGER.error("Failed creating proxy from abstract class", (Throwable)e);
            throw new RuntimeException("Failed creating proxy from abstract class", e);
        }
    }
}

