/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.commander.fileops;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.luwrain.app.commander.fileops.Operation;
import org.luwrain.app.commander.fileops.OperationListener;

public final class Unzip
extends Operation {
    private static final String CHARSET = "cp866";
    private final Path zipFile;
    private final Path destDir;

    public Unzip(OperationListener listener, String name, Path zipFile, Path destDir) {
        super(listener, name);
        Unzip.ensureValidLocalPath(zipFile);
        Unzip.ensureValidLocalPath(destDir);
        this.zipFile = zipFile;
        this.destDir = destDir;
    }

    @Override
    public void work() throws IOException {
        try (ZipFile zipFile = new ZipFile(this.zipFile.toFile(), CHARSET, false);){
            Enumeration enumEntry = zipFile.getEntries();
            while (enumEntry.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)enumEntry.nextElement();
                InputStream is = zipFile.getInputStream(entry);
                if (is == null) continue;
                is.close();
            }
        }
    }

    @Override
    public int getPercent() {
        return 0;
    }
}

