/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.commander.fileops;

import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.luwrain.app.commander.fileops.CopyingBase;
import org.luwrain.app.commander.fileops.OperationListener;
import org.luwrain.core.NullCheck;

public class Move
extends CopyingBase {
    private final Path[] toMove;
    private final Path moveTo;

    public Move(OperationListener listener, String name, Path[] toMove, Path moveTo) {
        super(listener, name);
        NullCheck.notNullItems((Object[])toMove, (String)"toMove");
        NullCheck.notEmptyArray((Object[])toMove, (String)"toMove");
        NullCheck.notNull((Object)moveTo, (String)"moveTo");
        this.toMove = toMove;
        this.moveTo = moveTo;
    }

    @Override
    protected void work() throws IOException {
        Path dest = this.moveTo;
        if (!dest.isAbsolute()) {
            Path parent = this.toMove[0].getParent();
            NullCheck.notNull((Object)parent, (String)"parent");
            dest = parent.resolve(dest);
        }
        for (Path path : this.toMove) {
            if (!dest.startsWith(path)) continue;
            throw new IOException("LWR_INTERRUPTED");
        }
        if (this.toMove.length > 1) {
            this.multipleSource(dest);
        } else {
            this.singleSource(dest);
        }
    }

    private void multipleSource(Path dest) throws IOException {
        NullCheck.notNull((Object)dest, (String)"dest");
        if (!Move.isDirectory(dest, true)) {
            throw new IOException("LWR_MOVE_DEST_NOT_DIR");
        }
        block4: for (Path p : this.toMove) {
            Path d = dest.resolve(p.getFileName());
            if (Move.exists(d, false)) {
                switch (this.confirmOverwrite(d)) {
                    case SKIP: {
                        continue block4;
                    }
                    case CANCEL: {
                        throw new IOException("LWR_INTERRUPTED");
                    }
                    default: {
                        Files.delete(d);
                    }
                }
            }
            Files.move(p, d, StandardCopyOption.ATOMIC_MOVE);
        }
    }

    private void singleSource(Path dest) throws IOException {
        NullCheck.notNull((Object)dest, (String)"dest");
        Path d = Move.exists(dest, false) && Move.isDirectory(dest, true) ? dest.resolve(this.toMove[0].getFileName()) : dest;
        if (Move.exists(d, false)) {
            switch (this.confirmOverwrite(d)) {
                case SKIP: {
                    return;
                }
                case CANCEL: {
                    throw new IOException("LWR_INTERRUPTED");
                }
            }
            Files.delete(d);
        }
        this.status("singleSource:moving single path " + this.toMove[0].toString() + " to " + d.toString());
        try {
            Files.move(this.toMove[0], d, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException e) {
            this.status("singleSource:atomic move failed, launching moving through copying");
            return;
        }
    }

    private void movingThroughCopying() throws IOException {
        this.status("performing moving through copying to " + this.moveTo.toString());
        this.copy(this.toMove, this.moveTo);
        this.status("deleting source files");
        for (Path p : this.toMove) {
            this.status("deleting " + p.toString());
            this.deleteFileOrDir(p);
        }
    }
}

