/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.commander.fileops;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.luwrain.app.commander.fileops.Operation;
import org.luwrain.app.commander.fileops.OperationListener;
import org.luwrain.core.NullCheck;
import org.luwrain.util.StreamUtils;

abstract class CopyingBase
extends Operation {
    private long totalBytes = 0L;
    private long processedBytes = 0L;
    private int percent = 0;
    private int lastPercent = 0;

    CopyingBase(OperationListener listener, String name) {
        super(listener, name);
    }

    @Override
    public int getPercent() {
        return this.percent;
    }

    protected void copy(Path[] toCopy, Path dest) throws IOException {
        NullCheck.notNullItems((Object[])toCopy, (String)"toCopy");
        NullCheck.notEmptyArray((Object[])toCopy, (String)"toCopy");
        NullCheck.notNull((Object)dest, (String)"dest");
        for (Path p : toCopy) {
            if (p.isAbsolute()) continue;
            throw new IllegalArgumentException("Paths of all source files must be absolute");
        }
        this.totalBytes = 0L;
        for (Path f : toCopy) {
            this.status("calculating size of " + String.valueOf(f));
            this.totalBytes += CopyingBase.getTotalSize(f);
        }
        this.status("total size is " + String.valueOf(this.totalBytes));
        Path d = dest;
        if (!d.isAbsolute()) {
            Path parent = toCopy[0].getParent();
            NullCheck.notNull((Object)parent, (String)"parent");
            d = parent.resolve(d);
            this.status("absolute destination path:" + d.toString());
        }
        for (Path path : toCopy) {
            if (!d.startsWith(path)) continue;
            throw new IOException("LWR_SOURCE_IS_A_PARENT_OF_THE_DEST");
        }
        if (toCopy.length == 1) {
            this.singleSource(toCopy[0], d);
        } else {
            this.multipleSource(toCopy, d);
        }
    }

    private void singleSource(Path fileFrom, Path dest) throws IOException {
        this.status("single source mode:copying " + String.valueOf(fileFrom) + " to " + String.valueOf(dest));
        if (CopyingBase.isDirectory(dest, true)) {
            this.status(String.valueOf(dest) + " exists and is a directory (or a symlink to a directory), copying the source file to it");
            this.copyRecurse(new Path[]{fileFrom}, dest);
            return;
        }
        if (CopyingBase.isDirectory(fileFrom, false)) {
            this.status(String.valueOf(fileFrom) + " is a directory and isn't a symlink");
            if (CopyingBase.exists(dest, false)) {
                switch (this.confirmOverwrite(dest)) {
                    case SKIP: {
                        return;
                    }
                    case CANCEL: {
                        throw new IOException("LWR_INTERRUPTED");
                    }
                }
                this.status("deleting previously existing " + dest.toString());
                Files.delete(dest);
            }
            Files.createDirectories(dest, new FileAttribute[0]);
            this.copyRecurse(CopyingBase.getDirContent(fileFrom), dest);
            return;
        }
        if (!Files.isSymbolicLink(fileFrom) && !CopyingBase.isRegularFile(fileFrom, false)) {
            this.status(String.valueOf(fileFrom) + "is not a symlink and is not a regular file, nothing to do");
            return;
        }
        this.status(String.valueOf(fileFrom) + " is a symlink or a regular file");
        if (CopyingBase.exists(dest, false)) {
            this.status(String.valueOf(dest) + " exists, trying to overwrite it");
            switch (this.confirmOverwrite(dest)) {
                case SKIP: {
                    return;
                }
                case CANCEL: {
                    throw new IOException("LWR_INTERRUPTED");
                }
            }
            Files.delete(dest);
        }
        if (dest.getParent() != null) {
            Files.createDirectories(dest.getParent(), new FileAttribute[0]);
        }
        this.copySingleFile(fileFrom, dest);
    }

    private void multipleSource(Path[] toCopy, Path dest) throws IOException {
        this.status("multiple source mode");
        if (CopyingBase.exists(dest, false) && !CopyingBase.isDirectory(dest, true)) {
            this.status(dest.toString() + " exists and is not a directory");
            switch (this.confirmOverwrite(dest)) {
                case SKIP: {
                    return;
                }
                case CANCEL: {
                    throw new IOException("LWR_INTERRUPTED");
                }
            }
            this.status("deleting previously existing " + dest.toString());
            Files.delete(dest);
        }
        if (!CopyingBase.exists(dest, false)) {
            Files.createDirectories(dest, new FileAttribute[0]);
        }
        this.copyRecurse(toCopy, dest);
    }

    private void copyRecurse(Path[] filesFrom, Path fileTo) throws IOException {
        NullCheck.notNullItems((Object[])filesFrom, (String)"filesFrom");
        NullCheck.notNull((Object)fileTo, (String)"fileTo");
        this.status("copyRecurse:copying " + filesFrom.length + " entries to " + String.valueOf(fileTo));
        block4: for (Path f : filesFrom) {
            if (!CopyingBase.isDirectory(f, false)) {
                this.status(f.toString() + " is not a directory, copying it");
                this.copyFileToDir(f, fileTo);
                continue;
            }
            this.status(f.toString() + " is a directory");
            Path newDest = fileTo.resolve(f.getFileName());
            this.status("new destination is " + newDest.toString());
            if (CopyingBase.exists(newDest, false) && !CopyingBase.isDirectory(newDest, true)) {
                this.status(String.valueOf(newDest) + " already exists and isn't a directory, asking confirmation and trying to delete it");
                switch (this.confirmOverwrite(newDest)) {
                    case SKIP: {
                        continue block4;
                    }
                    case CANCEL: {
                        throw new IOException("INTERRUPTED");
                    }
                    default: {
                        this.status("deleting previously existing " + newDest.toString());
                        Files.delete(newDest);
                    }
                }
            }
            if (!CopyingBase.exists(newDest, false)) {
                Files.createDirectories(newDest, new FileAttribute[0]);
            }
            this.status(String.valueOf(newDest) + " prepared");
            this.copyRecurse(CopyingBase.getDirContent(f), newDest);
        }
    }

    private void copyFileToDir(Path file, Path destDir) throws IOException {
        NullCheck.notNull((Object)file, (String)"file");
        NullCheck.notNull((Object)destDir, (String)"destDir");
        this.copySingleFile(file, destDir.resolve(file.getFileName()));
    }

    private void copySingleFile(Path fromFile, Path toFile) throws IOException {
        NullCheck.notNull((Object)fromFile, (String)"fromFile");
        NullCheck.notNull((Object)toFile, (String)"toFile");
        if (CopyingBase.exists(toFile, false)) {
            this.status(String.valueOf(toFile) + " already exists");
            switch (this.confirmOverwrite(toFile)) {
                case SKIP: {
                    return;
                }
                case CANCEL: {
                    throw new IOException("LWR_INTERRUPTED");
                }
            }
            Files.delete(toFile);
        }
        if (Files.isSymbolicLink(fromFile)) {
            Files.createSymbolicLink(toFile, Files.readSymbolicLink(fromFile), new FileAttribute[0]);
            return;
        }
        try (InputStream in = Files.newInputStream(fromFile, new OpenOption[0]);
             OutputStream out = Files.newOutputStream(toFile, new OpenOption[0]);){
            StreamUtils.copyAllBytes((InputStream)in, (OutputStream)out, (chunkNumBytes, totalNumBytes) -> this.onNewChunk(chunkNumBytes), () -> this.interrupted);
            out.flush();
            if (this.interrupted) {
                throw new IOException("INTERRUPTED");
            }
        }
    }

    private void onNewChunk(int bytes) {
        this.processedBytes += (long)bytes;
        long lPercent = this.processedBytes * 100L / this.totalBytes;
        this.percent = (int)lPercent;
        if (this.percent > this.lastPercent) {
            this.onProgress(this);
            this.lastPercent = this.percent;
        }
    }
}

