/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.commander;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Objects;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.ftp.FtpFileObject;
import org.apache.commons.vfs2.provider.local.LocalFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.controls.CommanderArea;
import org.luwrain.controls.CommanderUtils;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.ListUtils;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.queries.CurrentDirQuery;
import org.luwrain.io.vfs.CommanderModel;
import org.luwrain.io.vfs.CommanderUtils;

class PanelArea
extends CommanderArea<FileObject> {
    private static final Logger log = LogManager.getLogger();
    private final Luwrain luwrain;

    PanelArea(CommanderArea.Params<FileObject> params, Luwrain luwrain) {
        super(params);
        this.luwrain = luwrain;
    }

    public CommanderModel getCommanderModel() {
        return (CommanderModel)super.getCommanderModel();
    }

    void open(File file) {
        try {
            this.open(this.getCommanderModel().getFileSystemManager().resolveFile(file.getAbsolutePath()));
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean onAreaQuery(AreaQuery query) {
        if (query.getQueryCode() == 5 && query instanceof CurrentDirQuery) {
            CurrentDirQuery currentDirQuery = (CurrentDirQuery)query;
            File f = PanelArea.asFile((FileObject)this.opened());
            if (f == null) {
                return false;
            }
            currentDirQuery.answer(f.getAbsolutePath());
            return true;
        }
        return super.onAreaQuery(query);
    }

    boolean isLocalDir() {
        FileObject o = (FileObject)this.opened();
        if (o == null) {
            return false;
        }
        return o instanceof LocalFile;
    }

    FileObject[] getToProcess() {
        FileObject[] fileObjectArray;
        ArrayList<FileObject> res = new ArrayList<FileObject>();
        for (Object o : this.getMarked()) {
            res.add((FileObject)o);
        }
        if (!res.isEmpty()) {
            return res.toArray(new FileObject[res.size()]);
        }
        FileObject entry = (FileObject)this.getSelectedEntry();
        if (entry != null) {
            FileObject[] fileObjectArray2 = new FileObject[1];
            fileObjectArray = fileObjectArray2;
            fileObjectArray2[0] = entry;
        } else {
            fileObjectArray = new FileObject[]{};
        }
        return fileObjectArray;
    }

    boolean openLocalPath(String path) {
        Objects.requireNonNull(path, "path can't be null");
        try {
            this.open(CommanderUtils.createInitialFileObject((CommanderModel)this.getCommanderModel(), (String)path));
            return true;
        }
        catch (FileSystemException e) {
            Log.error((String)"commander", (String)("opening " + path + ":" + ((Object)((Object)e)).getClass().getName() + ":" + e.getMessage()));
            return false;
        }
    }

    boolean openInitial(String path) {
        try {
            return this.open(CommanderUtils.createInitialFileObject((CommanderModel)this.getCommanderModel(), (String)path), false);
        }
        catch (FileSystemException e) {
            Log.error((String)"commander", (String)("opening " + path + ":" + ((Object)((Object)e)).getClass().getName() + ":" + e.getMessage()));
            return false;
        }
    }

    void showHidden() {
        this.setCommanderFilter((CommanderArea.Filter)new CommanderUtils.AllEntriesFilter());
        this.reread(false);
    }

    void hideHidden() {
        this.setCommanderFilter((CommanderArea.Filter)new CommanderUtils.NoHiddenFilter());
        this.reread(false);
    }

    static Path asPath(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        if (fileObject instanceof LocalFile) {
            return Paths.get(fileObject.getName().getPath(), new String[0]);
        }
        return null;
    }

    static File asFile(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        if (fileObject instanceof LocalFile) {
            return new File(fileObject.getName().getPath());
        }
        return null;
    }

    URL asUrl(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        if (fileObject instanceof FtpFileObject) {
            FtpFileObject ftpFile = (FtpFileObject)fileObject;
            try {
                URL root = new URL(ftpFile.getFileSystem().getRootURI());
                return new URL(root, fileObject.getName().getPath());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }

    static Path[] asPath(FileObject[] fileObjects) {
        NullCheck.notNullItems((Object[])fileObjects, (String)"fileObjects");
        ArrayList<Path> res = new ArrayList<Path>();
        for (FileObject f : fileObjects) {
            Path ff = PanelArea.asPath(f);
            if (ff == null) continue;
            res.add(ff);
        }
        return res.toArray(new Path[res.size()]);
    }

    static File[] asFile(FileObject[] fileObjects) {
        NullCheck.notNullItems((Object[])fileObjects, (String)"fileObjects");
        ArrayList<File> res = new ArrayList<File>();
        for (FileObject f : fileObjects) {
            File ff = PanelArea.asFile(f);
            if (ff == null) continue;
            res.add(ff);
        }
        return res.toArray(new File[res.size()]);
    }

    static CommanderArea.Params<FileObject> createParams(ControlContext controlContext) {
        try {
            CommanderArea.Params params = CommanderUtils.createParams((ControlContext)Objects.requireNonNull(controlContext, "controlContext can't be null"));
            params.flags = EnumSet.of(CommanderArea.Flags.MARKING);
            params.filter = new CommanderUtils.NoHiddenFilter();
            params.clipboardSaver = new ListUtils.FunctionalClipboardSaver(entry -> PanelArea.asFile((FileObject)entry.getNativeObj()), entry -> entry.getBaseName());
            return params;
        }
        catch (FileSystemException e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }
}

