/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.commander;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.base.TaskCancelling;
import org.luwrain.app.commander.App;
import org.luwrain.app.commander.OperationsNames;
import org.luwrain.app.commander.PanelArea;
import org.luwrain.app.commander.Strings;
import org.luwrain.app.commander.fileops.Copy;
import org.luwrain.app.commander.fileops.Delete;
import org.luwrain.app.commander.fileops.Move;
import org.luwrain.app.commander.fileops.ZipCompress;
import org.luwrain.app.commander.layouts.CommandOutputLayout;
import org.luwrain.core.EmptyJobListener;
import org.luwrain.core.Job;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.io.json.Message;
import org.luwrain.util.PathUtils;

final class FileActions
extends OperationsNames {
    private static final Logger log = LogManager.getLogger();

    FileActions(App app) {
        super(app);
    }

    boolean size(PanelArea panelArea) {
        FileObject[] files = panelArea.getToProcess();
        if (files.length == 0) {
            return false;
        }
        TaskCancelling.TaskId taskId = this.app.newTaskId();
        return this.app.runTask(taskId, () -> {
            long res;
            try {
                res = this.getSize(files);
            }
            catch (FileSystemException e) {
                this.app.getLuwrain().crash((Throwable)e);
                return;
            }
            this.app.finishedTask(taskId, () -> this.app.getLuwrain().message(String.valueOf(res)));
        });
    }

    private long getSize(FileObject fileObj) throws FileSystemException {
        if (fileObj.getType().hasChildren()) {
            return this.getSize(fileObj.getChildren());
        }
        if (fileObj.isFile() && !fileObj.isSymbolicLink()) {
            return fileObj.getContent().getSize();
        }
        return 0L;
    }

    private long getSize(FileObject[] files) throws FileSystemException {
        long sum = 0L;
        for (FileObject f : files) {
            sum += this.getSize(f);
        }
        return sum;
    }

    boolean localCopy(PanelArea copyFromArea, PanelArea copyToArea) {
        if (!copyFromArea.isLocalDir() || !copyToArea.isLocalDir()) {
            return false;
        }
        Path copyFromDir = PanelArea.asPath((FileObject)copyFromArea.opened());
        if (copyFromDir == null || !copyFromDir.isAbsolute() || !Files.isDirectory(copyFromDir, new LinkOption[0])) {
            return false;
        }
        Path[] filesToCopy = PanelArea.asPath(copyFromArea.getToProcess());
        if (filesToCopy.length == 0) {
            return false;
        }
        Path copyToDir = PanelArea.asPath((FileObject)copyToArea.opened());
        if (copyToDir == null || !copyToDir.isAbsolute() || !Files.isDirectory(copyToDir, new LinkOption[0])) {
            return false;
        }
        Path dest = this.app.getConv().copy(copyFromDir, filesToCopy, copyToDir);
        if (dest == null) {
            return true;
        }
        String name = this.copyOperationName(filesToCopy, dest);
        Copy copy = new Copy(this.app.opListener, name, filesToCopy, dest);
        this.app.runOperation(copy);
        return true;
    }

    boolean localMove(PanelArea moveFromArea, PanelArea moveToArea) {
        if (!moveFromArea.isLocalDir() || !moveToArea.isLocalDir()) {
            return false;
        }
        Path moveFromDir = PanelArea.asPath((FileObject)moveFromArea.opened());
        if (moveFromDir == null || !moveFromDir.isAbsolute() || !Files.isDirectory(moveFromDir, new LinkOption[0])) {
            return false;
        }
        Path[] filesToMove = PanelArea.asPath(moveFromArea.getToProcess());
        if (filesToMove.length == 0) {
            return false;
        }
        Path moveToDir = PanelArea.asPath((FileObject)moveToArea.opened());
        if (moveToDir == null || !moveToDir.isAbsolute() || !Files.isDirectory(moveToDir, new LinkOption[0])) {
            return false;
        }
        Path dest = this.app.getConv().move(moveFromDir, filesToMove, moveToDir);
        if (dest == null) {
            return true;
        }
        String name = this.moveOperationName(filesToMove, dest);
        Move move = new Move(this.app.opListener, name, filesToMove, dest);
        this.app.runOperation(move);
        return true;
    }

    boolean localMkdir(PanelArea panelArea) {
        if (!panelArea.isLocalDir()) {
            return false;
        }
        File createIn = PanelArea.asFile((FileObject)panelArea.opened());
        if (createIn == null || !createIn.isAbsolute()) {
            return false;
        }
        File newDir = this.app.getConv().mkdirPopup(createIn);
        if (newDir == null) {
            return true;
        }
        try {
            Files.createDirectories(newDir.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            this.app.getLuwrain().crash((Throwable)e);
            return true;
        }
        this.app.getLuwrain().message(((Strings)this.app.getStrings()).mkdirOkMessage(newDir.getName()), Luwrain.MessageType.OK);
        panelArea.reread(newDir.getName(), false);
        return true;
    }

    boolean localDelete(PanelArea area) {
        NullCheck.notNull((Object)((Object)area), (String)"area");
        if (!area.isLocalDir()) {
            return false;
        }
        Path[] files = PanelArea.asPath(area.getToProcess());
        if (files.length == 0) {
            return false;
        }
        if (!this.app.getConv().deleteConfirmation(files)) {
            return true;
        }
        String opName = "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435";
        Log.debug((String)"proba", (String)"preparing");
        this.app.runOperation(new Delete(this.app.opListener, "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", files));
        return true;
    }

    boolean localRun(PanelArea panelArea) {
        if (!panelArea.isLocalDir()) {
            return false;
        }
        Path dir = PanelArea.asPath((FileObject)panelArea.opened());
        if (dir == null) {
            return false;
        }
        Path[] toProcess = PanelArea.asPath(panelArea.getToProcess());
        if (toProcess.length == 0) {
            return false;
        }
        String cmd = this.app.getConv().run();
        if (cmd == null || cmd.trim().isEmpty()) {
            return true;
        }
        StringBuilder b = new StringBuilder();
        int pos = cmd.indexOf(" *");
        if (pos < 0) {
            b.append(cmd.trim());
            for (Path p : toProcess) {
                b.append(" ").append(PathUtils.escapeBash((String)p.toString()));
            }
        } else {
            b.append(cmd.substring(0, pos).trim());
            for (Path p : toProcess) {
                b.append(" ").append(PathUtils.escapeBash((String)p.toString()));
            }
            b.append(" ").append(cmd.substring(pos + 2).trim());
        }
        final AtomicReference<Object> output = new AtomicReference<Object>(null);
        this.app.getLuwrain().newJob("sys", new String[]{new String(b)}, dir.toAbsolutePath().toString(), EnumSet.noneOf(Luwrain.JobFlags.class), (Job.Listener)new EmptyJobListener(){

            public void onInfoChange(Job instance, String infoType, List<String> value) {
                log.debug("Job info change: " + instance.getInstanceName() + ", type '" + infoType + "'");
                if (!infoType.equals("main")) {
                    return;
                }
                FileActions.this.app.getLuwrain().runUiSafely(() -> {
                    if (output.get() == null) {
                        output.set(new CommandOutputLayout(FileActions.this.app, instance));
                        FileActions.this.app.setAreaLayout((LayoutBase)output.get());
                    } else {
                        ((CommandOutputLayout)((Object)((Object)output.get()))).update(value);
                    }
                });
            }
        });
        return true;
    }

    boolean localMail(PanelArea panelArea) {
        if (!panelArea.isLocalDir()) {
            return false;
        }
        Path[] toProcess = PanelArea.asPath(panelArea.getToProcess());
        if (toProcess.length == 0) {
            return false;
        }
        for (Path p : toProcess) {
            if (!Files.isDirectory(p, new LinkOption[0])) continue;
            this.app.message("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043f\u043e \u043f\u043e\u0447\u0442\u0435 \u043a\u0430\u0442\u0430\u043b\u043e\u0433", Luwrain.MessageType.ERROR);
            return true;
        }
        ArrayList<String> files = new ArrayList<String>();
        for (Path p : toProcess) {
            files.add(p.toAbsolutePath().toString());
        }
        Message message = new Message();
        message.setAttachments(files);
        this.app.getLuwrain().launchApp("message", new String[]{message.toString()});
        return true;
    }

    boolean zipCompress(PanelArea panelArea) {
        Path[] toProcess = PanelArea.asPath(panelArea.getToProcess());
        if (toProcess.length == 0) {
            return false;
        }
        ZipCompress zipCompress = new ZipCompress(this.app.opListener, "zip", toProcess, Paths.get("/tmp/proba.zip", new String[0]));
        TaskCancelling.TaskId taskId = this.app.newTaskId();
        return this.app.runTask(taskId, () -> zipCompress.run());
    }
}

