/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.inlandes;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.luwrain.inlandes.DictLang;
import org.luwrain.inlandes.GraalVmEngine;
import org.luwrain.inlandes.Lang;
import org.luwrain.inlandes.Matcher;
import org.luwrain.inlandes.Operation;
import org.luwrain.inlandes.RuleStatement;
import org.luwrain.inlandes.ScriptEngine;
import org.luwrain.inlandes.SyntaxParser;
import org.luwrain.inlandes.Token;
import org.luwrain.inlandes.util.Tokenizer;

public final class Inlandes
implements AutoCloseable {
    private static final int NO_REF = -1;
    private final Map<String, Set<String>> dicts = new HashMap<String, Set<String>>();
    private final SortedMap<Integer, List<RuleStatement>> rules = new TreeMap<Integer, List<RuleStatement>>();
    private final List<RuleStatement> rulesList = new ArrayList<RuleStatement>();
    private final SyntaxParser parser;
    private final ScriptEngine scriptEngine;
    private final Lang lang;
    private int currentStageNum = 0;

    public Inlandes(ScriptEngine scriptEngine, Lang lang) {
        if (scriptEngine == null) {
            throw new NullPointerException("scriptEngine can't be null");
        }
        if (lang == null) {
            throw new NullPointerException("lang can't be null");
        }
        this.scriptEngine = scriptEngine;
        this.lang = lang;
        this.parser = new SyntaxParser(scriptEngine, lang, this.dicts);
    }

    public Inlandes() {
        this(new GraalVmEngine(), new DictLang());
    }

    public Token[] process(Token[] tokens) {
        ArrayList<Token[]> history = new ArrayList<Token[]>();
        history.add(tokens);
        for (Map.Entry<Integer, List<RuleStatement>> e : this.rules.entrySet()) {
            Token[] t;
            Matcher m = new Matcher(e.getValue().toArray(new RuleStatement[e.getValue().size()]));
            Matcher.Matching[] matchings = this.handleCollisions(m.match(t = (Token[])history.get(history.size() - 1)));
            if (matchings.length == 0) continue;
            history.add(this.processMatchings(t, matchings));
        }
        return (Token[])history.get(history.size() - 1);
    }

    public Token[] process(String text) {
        return this.process(Tokenizer.tokenize(text));
    }

    private Matcher.Matching[] handleCollisions(List<Matcher.Matching> m) {
        for (int i2 = 0; i2 < m.size(); ++i2) {
            Matcher.Matching mi = m.get(i2);
            if (mi == null) continue;
            for (int j = i2 + 1; j < m.size(); ++j) {
                Matcher.Matching mj = m.get(j);
                if (mj == null || !mi.overlaps(mj)) continue;
                if (mj.len < mi.len) {
                    m.set(j, null);
                    continue;
                }
                m.set(i2, null);
                j = m.size();
            }
        }
        m.removeIf(i -> i == null);
        return m.toArray(new Matcher.Matching[m.size()]);
    }

    private Token[] processMatchings(Token[] tokens, Matcher.Matching[] matchings) {
        ArrayList<Operation.Execution> execs = new ArrayList<Operation.Execution>();
        for (Matcher.Matching m : matchings) {
            for (Operation o : m.getRule().operations) {
                execs.add(o.getExecution(tokens, m));
            }
        }
        Token[] t = (Token[])tokens.clone();
        int numRemoved = 0;
        for (Operation.Execution a : execs) {
            if (a.rangeFrom == -1 || a.rangeTo == -1) {
                a.exec(this.scriptEngine);
                continue;
            }
            if (a.rangeFrom == a.rangeTo) continue;
            t[a.rangeFrom] = a.exec(this.scriptEngine);
            for (int i = a.rangeFrom + 1; i < a.rangeTo; ++i) {
                t[i] = null;
            }
            numRemoved += a.rangeTo - a.rangeFrom;
            if (t[a.rangeFrom] == null) continue;
            --numRemoved;
        }
        ArrayList<Token> res = new ArrayList<Token>();
        res.ensureCapacity(t.length - numRemoved);
        for (Token tt : t) {
            if (tt == null) continue;
            res.add(tt);
        }
        return res.toArray(new Token[res.size()]);
    }

    public void addDict(String dictName, List<String> items) {
        if (dictName == null) {
            throw new NullPointerException("dictName can't be null");
        }
        if (dictName.trim().isEmpty()) {
            throw new IllegalArgumentException("dictName can't be empty");
        }
        this.dicts.put(dictName.trim(), new HashSet<String>(items));
    }

    public void loadStandardLibrary() {
        try {
            this.dicts.put("roman", new HashSet<String>(Arrays.asList(this.readTextResourceAsArray("roman.dict", "UTF-8"))));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void loadRules(String rulesText) {
        RuleStatement[] rr = this.parser.parse(rulesText);
        this.rulesList.addAll(Arrays.asList(rr));
        for (RuleStatement r : rr) {
            if (r.isDefaultStageNum()) {
                r.setStageNum(this.currentStageNum);
            }
            this.currentStageNum = r.getStageNum();
            Integer num = new Integer(this.currentStageNum);
            ArrayList<RuleStatement> l = (ArrayList<RuleStatement>)this.rules.get(num);
            if (l != null) {
                l.add(r);
                continue;
            }
            l = new ArrayList<RuleStatement>();
            l.add(r);
            this.rules.put(num, l);
        }
    }

    public void loadRulesFromFile(String fileName, String charset) throws IOException {
        this.loadRules(this.readTextFile(fileName, charset));
    }

    public void loadRulesFromFile(String fileName) throws IOException {
        this.loadRulesFromFile(fileName, "UTF-8");
    }

    @Override
    public void close() throws Exception {
        this.scriptEngine.close();
    }

    public int getStageCount() {
        return this.rules.size();
    }

    public int getRuleCount() {
        return this.rulesList.size();
    }

    public RuleStatement getRule(int index) {
        return this.rulesList.get(index);
    }

    private String readTextFile(String fileName, String charset) throws IOException {
        try (BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), charset));){
            String line = r.readLine();
            StringBuilder b = new StringBuilder();
            while (line != null) {
                if (!line.trim().isEmpty() && line.trim().charAt(0) != '#') {
                    b.append(line);
                }
                b.append(System.lineSeparator());
                line = r.readLine();
            }
            String string = new String(b);
            return string;
        }
    }

    private String[] readTextFileAsArray(String fileName, String charset) throws IOException {
        try (BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), charset));){
            String line = r.readLine();
            ArrayList<String> res = new ArrayList<String>();
            while (line != null) {
                if (!line.trim().isEmpty() && line.trim().charAt(0) != '#') {
                    res.add(line);
                }
                line = r.readLine();
            }
            String[] stringArray = res.toArray(new String[res.size()]);
            return stringArray;
        }
    }

    private String[] readTextResourceAsArray(String resName, String charset) throws IOException {
        try (BufferedReader r = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(resName), charset));){
            String line = r.readLine();
            ArrayList<String> res = new ArrayList<String>();
            while (line != null) {
                if (!line.trim().isEmpty() && line.trim().charAt(0) != '#') {
                    res.add(line);
                }
                line = r.readLine();
            }
            String[] stringArray = res.toArray(new String[res.size()]);
            return stringArray;
        }
    }
}

