/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.vk2.layouts;

import com.vk.api.sdk.objects.users.UserFull;
import java.util.List;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.base.TaskCancelling;
import org.luwrain.app.vk2.App;
import org.luwrain.app.vk2.AppSection;
import org.luwrain.app.vk2.UserAppearance;
import org.luwrain.app.vk2.UserProfileLayout;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.core.Area;

public final class FriendsLayout
extends AppSection {
    public final ListArea<UserFull> friendsArea = new ListArea(this.listParams(params -> {
        params.name = "\u0414\u0440\u0443\u0437\u044c\u044f";
        params.model = new ListUtils.ListModel(app.friends);
        params.appearance = new UserAppearance(app);
        params.clickHandler = this::openUser;
    }));

    public FriendsLayout(App app) {
        super(app);
        this.setAreaLayout((Area)this.friendsArea, this.actions(new LayoutBase.ActionInfo[0]));
    }

    private boolean openUser(ListArea<UserFull> area, int index, UserFull user) {
        TaskCancelling.TaskId taskId = this.app.newTaskId();
        return this.app.runTask(taskId, () -> {
            List<UserFull> f = this.app.getOperations().getFriends(user.getId());
            this.app.finishedTask(taskId, () -> {
                UserProfileLayout layout = new UserProfileLayout(this.app, f, () -> {
                    this.app.setAreaLayout(this);
                    this.setActiveArea((Area)this.friendsArea);
                    return true;
                });
                this.app.setAreaLayout(layout);
                this.getLuwrain().announceActiveArea();
            });
        });
    }
}

