/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.vk2;

import com.vk.api.sdk.objects.base.Sex;
import com.vk.api.sdk.objects.users.UserFull;
import com.vk.api.sdk.objects.users.UserRelation;
import java.util.Set;
import org.luwrain.app.vk2.App;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Sounds;
import org.luwrain.core.Suggestions;

public final class UserAppearance
extends ListUtils.AbstractAppearance<UserFull> {
    final App app;

    public UserAppearance(App app) {
        this.app = app;
    }

    public void announceItem(UserFull user, Set<ListArea.Appearance.Flags> flags) {
        String age = this.app.birthdayUtils.getAge(user.getBdate());
        StringBuilder b = new StringBuilder();
        b.append(this.app.getUserCommonName(user.getId()));
        if (!age.isEmpty()) {
            b.append(", ").append(age);
        }
        if (user.getRelation() != null && user.getRelation() != UserRelation.NOT_SPECIFIED) {
            b.append(", ").append(UserAppearance.getRelationDescr(user));
        }
        this.app.setEventResponse(DefaultEventResponse.listItem((Sounds)Sounds.LIST_ITEM, (String)new String(b), (Suggestions)Suggestions.CLICKABLE_LIST_ITEM));
    }

    public String getScreenAppearance(UserFull user, Set<ListArea.Appearance.Flags> flags) {
        return this.app.getUserCommonName(user.getId());
    }

    static String getRelationDescr(UserFull user) {
        if (user.getRelation() == null) {
            return "";
        }
        if (user.getSex() == Sex.MALE) {
            switch (user.getRelation()) {
                case SINGLE: {
                    return "\u0425\u043e\u043b\u043e\u0441\u0442";
                }
                case ENGAGED: {
                    return "\u041f\u043e\u043c\u043e\u043b\u0432\u043b\u0435\u043d";
                }
                case MARRIED: {
                    return "\u0416\u0435\u043d\u0430\u0442";
                }
                case IN_LOVE: {
                    return "\u0412\u043b\u044e\u0431\u043b\u0451\u043d";
                }
            }
        }
        if (user.getSex() == Sex.FEMALE) {
            switch (user.getRelation()) {
                case SINGLE: {
                    return "\u041d\u0435 \u0437\u0430\u043c\u0443\u0436\u0435\u043c";
                }
                case ENGAGED: {
                    return "\u041f\u043e\u043c\u043e\u043b\u0432\u043b\u0435\u043d\u0430";
                }
                case MARRIED: {
                    return "\u0417\u0430\u043c\u0443\u0436\u0435\u043c";
                }
                case IN_LOVE: {
                    return "\u0412\u043b\u044e\u0431\u043b\u0435\u043d\u0430";
                }
            }
        }
        switch (user.getRelation()) {
            case NOT_SPECIFIED: {
                return "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e";
            }
            case SINGLE: {
                return "\u0425\u043e\u043b\u043e\u0441\u0442/\u043d\u0435 \u0437\u0430\u043c\u0443\u0436\u0435\u043c";
            }
            case IN_A_RELATIONSHIP: {
                return "\u0412 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u044f\u0445";
            }
            case ENGAGED: {
                return "\u041f\u043e\u043c\u043e\u043b\u0432\u043b\u0435\u043d/\u043f\u043e\u043c\u043e\u043b\u0432\u043b\u0435\u043d\u0430";
            }
            case MARRIED: {
                return "\u0416\u0435\u043d\u0430\u0442/\u0437\u0430\u043c\u0443\u0436\u0435\u043c";
            }
            case COMPLICATED: {
                return "\u041d\u0435\u043f\u043e\u043d\u044f\u0442\u043d\u043e";
            }
            case ACTIVELY_SEARCHING: {
                return "\u0412 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u043c \u043f\u043e\u0438\u0441\u043a\u0435";
            }
            case IN_LOVE: {
                return "\u0412\u043b\u044e\u0431\u043b\u0451\u043d/\u0432\u043b\u044e\u0431\u043b\u0435\u043d\u0430";
            }
            case IN_A_CIVIL_UNION: {
                return "\u0412 \u0433\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u043c \u0431\u0440\u0430\u043a\u0435";
            }
        }
        return user.getRelation().toString();
    }
}

