/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.vk2;

import com.vk.api.sdk.objects.messages.ConversationWithMessage;
import com.vk.api.sdk.objects.newsfeed.ItemWallpost;
import com.vk.api.sdk.objects.users.UserFull;
import com.vk.api.sdk.objects.wall.WallpostFull;
import com.vk.api.sdk.oneofs.NewsfeedNewsfeedItemOneOf;
import java.util.List;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.base.TaskCancelling;
import org.luwrain.app.vk.Strings;
import org.luwrain.app.vk2.App;
import org.luwrain.app.vk2.AppSection;
import org.luwrain.app.vk2.ChatsAppearance;
import org.luwrain.app.vk2.NewsAppearance;
import org.luwrain.app.vk2.WallPostLayout;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.SystemEvent;

public final class MainLayout
extends AppSection {
    final ListArea<NewsfeedNewsfeedItemOneOf> newsArea = new ListArea<NewsfeedNewsfeedItemOneOf>(this.listParams(params -> {
        params.name = "\u041d\u043e\u0432\u043e\u0441\u0442\u0438";
        params.model = new ListUtils.ListModel(app.news);
        params.appearance = new NewsAppearance(app);
        params.clickHandler = this::onNewsClick;
    })){

        public boolean onSystemEvent(SystemEvent event) {
            if (event.getType() == SystemEvent.Type.REGULAR) {
                switch (event.getCode()) {
                    case SAVE: {
                        return MainLayout.this.onAddLike();
                    }
                }
            }
            return super.onSystemEvent(event);
        }
    };
    final ListArea<ConversationWithMessage> chatsArea = new ListArea(this.listParams(params -> {
        params.name = ((Strings)app.getStrings()).conversationsAreaName();
        params.model = new ListUtils.ListModel(app.chats);
        params.appearance = new ChatsAppearance(app);
    }));

    public MainLayout(App app) {
        super(app);
        this.setAreaLayout(AreaLayout.LEFT_RIGHT, (Area)this.newsArea, this.actions(new LayoutBase.ActionInfo[0]), (Area)this.chatsArea, this.actions(new LayoutBase.ActionInfo[0]));
    }

    private boolean onNewsClick(ListArea<NewsfeedNewsfeedItemOneOf> area, int index, NewsfeedNewsfeedItemOneOf item) {
        ItemWallpost post = item.getOneOf0();
        if (post.getSourceId() == null || post.getPostId() == null) {
            return false;
        }
        TaskCancelling.TaskId taskId = this.app.newTaskId();
        return this.app.runTask(taskId, () -> {
            WallpostFull wallPost = this.app.getOperations().getWallPost(post.getSourceId().toString() + "_" + post.getPostId());
            List<UserFull> likes = this.app.getOperations().getLikesWallPost(wallPost.getOwnerId(), wallPost.getId());
            this.app.finishedTask(taskId, () -> {
                WallPostLayout layout = new WallPostLayout(this.app, wallPost, likes, () -> {
                    this.app.setAreaLayout(this);
                    this.setActiveArea((Area)this.newsArea);
                    return true;
                });
                this.app.setAreaLayout(layout);
                this.getLuwrain().announceActiveArea();
            });
        });
    }

    private boolean onAddLike() {
        NewsfeedNewsfeedItemOneOf item = (NewsfeedNewsfeedItemOneOf)this.newsArea.selected();
        if (item == null) {
            return false;
        }
        ItemWallpost post = item.getOneOf0();
        if (post.getSourceId() == null || post.getPostId() == null) {
            return false;
        }
        TaskCancelling.TaskId taskId = this.app.newTaskId();
        return this.app.runTask(taskId, () -> {
            WallpostFull wallPost = this.app.getOperations().getWallPost(post.getSourceId().toString() + "_" + post.getPostId());
            this.app.getOperations().addLikeWallPost(wallPost);
            this.app.finishedTask(taskId, () -> this.getLuwrain().playSound(Sounds.OK));
        });
    }
}

