/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.vk2;

import java.time.Year;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.luwrain.app.vk2.App;

public final class BirthdayUtils {
    static final Pattern PAT_FULL = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)$");
    final App app;

    BirthdayUtils(App app) {
        this.app = app;
    }

    String getAge(String birthday) {
        if (birthday == null || birthday.isEmpty()) {
            return "";
        }
        Matcher m = PAT_FULL.matcher(birthday);
        if (!m.find()) {
            return "";
        }
        int year = Integer.parseInt(m.group(3));
        int age = Year.now().getValue() - year;
        String suff = age % 100 > 10 && age % 100 < 20 ? "\u043b\u0435\u0442" : (age % 10 == 1 ? "\u0433\u043e\u0434" : (age % 10 >= 2 && age % 10 <= 4 ? "\u0433\u043e\u0434\u0430" : "\u043b\u0435\u0442"));
        return String.valueOf(age) + " " + suff;
    }
}

