/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.vk2;

import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.vk.Strings;
import org.luwrain.app.vk2.App;
import org.luwrain.controls.WizardArea;
import org.luwrain.core.Area;
import org.luwrain.core.Luwrain;

final class AuthLayout
extends LayoutBase {
    private final App app;
    final WizardArea wizardArea;

    AuthLayout(App app) {
        super((AppBase)app);
        this.app = app;
        this.wizardArea = new WizardArea(this.getControlContext());
        this.wizardArea.setAreaName(((Strings)app.getStrings()).appName());
        WizardArea.Frame frame = this.wizardArea.newFrame();
        frame.addText(((Strings)app.getStrings()).authIntro());
        frame.addInput(((Strings)app.getStrings()).authUserId(), "");
        frame.addInput(((Strings)app.getStrings()).authAccessToken(), "");
        frame.addClickable(((Strings)app.getStrings()).authConnect(), this::connect);
        this.wizardArea.show(frame);
        this.setAreaLayout((Area)this.wizardArea, null);
    }

    private boolean connect(WizardArea.WizardValues values) {
        int userIdValue;
        String userId = values.getText(0).trim();
        String accessToken = values.getText(1).trim();
        if (userId.isEmpty()) {
            this.app.message(((Strings)this.app.getStrings()).authInvalidUserId(), Luwrain.MessageType.ERROR);
            return true;
        }
        try {
            userIdValue = Integer.parseInt(userId);
        }
        catch (NumberFormatException e) {
            this.app.message(((Strings)this.app.getStrings()).authInvalidUserId(), Luwrain.MessageType.ERROR);
            return true;
        }
        if (userIdValue <= 0) {
            this.app.message(((Strings)this.app.getStrings()).authInvalidUserId(), Luwrain.MessageType.ERROR);
            return true;
        }
        if (accessToken.isEmpty()) {
            this.app.message(((Strings)this.app.getStrings()).authInvalidAccessToken(), Luwrain.MessageType.ERROR);
            return true;
        }
        this.app.onAuth(userIdValue, accessToken);
        return true;
    }
}

