/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.vk;

import java.io.File;
import java.util.LinkedList;
import org.luwrain.app.vk.ActionLists;
import org.luwrain.app.vk.Actions;
import org.luwrain.app.vk.Base;
import org.luwrain.app.vk.Strings;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.FormArea;
import org.luwrain.core.Action;
import org.luwrain.core.Event;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.ActionEvent;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;

final class WallPostArea
extends FormArea {
    private final Luwrain luwrain;
    private final Strings strings;
    private final Base base;
    private final Actions actions;
    private final ActionLists actionLists;
    private final Runnable closing;
    private int nextAttachmentNum = 0;

    WallPostArea(Luwrain luwrain, Strings strings, Base base, Actions actions, ActionLists actionLists, Runnable closing) {
        super((ControlContext)new DefaultControlContext(luwrain), strings.wallPostAreaName());
        NullCheck.notNull((Object)actions, (String)"actions");
        NullCheck.notNull((Object)actionLists, (String)"actionLists");
        NullCheck.notNull((Object)closing, (String)"closing");
        this.luwrain = luwrain;
        this.strings = strings;
        this.base = base;
        this.actions = actions;
        this.actionLists = actionLists;
        this.closing = closing;
        this.activateMultilineEdit("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0442\u0435\u043a\u0441\u0442 \u043d\u043e\u0432\u043e\u0439 \u0437\u0430\u043f\u0438\u0441\u0438 \u043d\u0438\u0436\u0435:", new String[0], true);
    }

    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.isSpecial() && !event.isModified()) {
            switch (event.getSpecial()) {
                case ESCAPE: {
                    this.closing.run();
                    return true;
                }
            }
        }
        return super.onInputEvent(event);
    }

    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.getType() != SystemEvent.Type.REGULAR) {
            return super.onSystemEvent(event);
        }
        switch (event.getCode()) {
            case ACTION: {
                if (ActionEvent.isAction((Event)event, (String)"attach-photo")) {
                    return this.onAttachPhoto();
                }
            }
            case OK: {
                LinkedList<File> photos = new LinkedList<File>();
                for (int i = 0; i < this.getItemCount(); ++i) {
                    if (this.getItemTypeOnLine(i) != FormArea.Type.STATIC || !this.getItemNameOnLine(i).startsWith("photo")) continue;
                    photos.add((File)this.getItemObj(i));
                }
                String text = this.getPostText();
                if (text.trim().isEmpty() && photos.isEmpty()) {
                    return false;
                }
                if (!this.actions.onWallPost(text, photos.toArray(new File[photos.size()]), () -> this.closing.run())) {
                    return false;
                }
                this.luwrain.message(this.strings.sendingPost());
                return true;
            }
            case CLOSE: {
                this.base.closeApp();
                return true;
            }
        }
        return super.onSystemEvent(event);
    }

    public Action[] getAreaActions() {
        return this.actionLists.getWallPostActions();
    }

    private boolean onAttachPhoto() {
        File file = this.actions.conv.attachPhoto();
        if (file == null) {
            return true;
        }
        this.addStatic("photo" + this.nextAttachmentNum, file.getName(), file);
        ++this.nextAttachmentNum;
        return true;
    }

    private String getPostText() {
        String[] lines = this.getMultilineEditText();
        if (lines.length == 0) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        b.append(lines[0]);
        for (int i = 1; i < lines.length - 1; ++i) {
            b.append("\n" + lines[i]);
        }
        return new String(b);
    }
}

